<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewAARQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewAARQuote
 * @subpackage Structs
 */
class ViewAARQuote extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The ApplicableTaxes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicableTax
     */
    public $ApplicableTaxes;
    /**
     * The BoardingPassSsrOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardingPassSsrOrder;
    /**
     * The CategoryID
     * @var int
     */
    public $CategoryID;
    /**
     * The Commissionable
     * @var bool
     */
    public $Commissionable;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CutoffHours
     * @var int
     */
    public $CutoffHours;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Display
     * @var bool
     */
    public $Display;
    /**
     * The DisplayOrder
     * @var int
     */
    public $DisplayOrder;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * The IATAStandardCodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IATAStandardCodeType;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The MarketingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MarketingCarrier;
    /**
     * The MaxCountFlightLevel
     * @var int
     */
    public $MaxCountFlightLevel;
    /**
     * The MaxCountServiceLevel
     * @var int
     */
    public $MaxCountServiceLevel;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The PTCID
     * @var int
     */
    public $PTCID;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The PriceAmountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PriceAmountID;
    /**
     * The QuantityAvailable
     * @var int
     */
    public $QuantityAvailable;
    /**
     * The Refundable
     * @var bool
     */
    public $Refundable;
    /**
     * The RevenueCategoryID
     * @var int
     */
    public $RevenueCategoryID;
    /**
     * The SSRCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SSRCode;
    /**
     * The ServiceActive
     * @var bool
     */
    public $ServiceActive;
    /**
     * The ServiceID
     * @var int
     */
    public $ServiceID;
    /**
     * The StartSalesDays
     * @var int
     */
    public $StartSalesDays;
    /**
     * The PNLActive
     * @var bool
     */
    public $PNLActive;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ServiceType;
    /**
     * Constructor method for ViewAARQuote
     * @uses ViewAARQuote::setAmount()
     * @uses ViewAARQuote::setApplicableTaxes()
     * @uses ViewAARQuote::setBoardingPassSsrOrder()
     * @uses ViewAARQuote::setCategoryID()
     * @uses ViewAARQuote::setCommissionable()
     * @uses ViewAARQuote::setCurrencyCode()
     * @uses ViewAARQuote::setCutoffHours()
     * @uses ViewAARQuote::setDepartureDate()
     * @uses ViewAARQuote::setDescription()
     * @uses ViewAARQuote::setDisplay()
     * @uses ViewAARQuote::setDisplayOrder()
     * @uses ViewAARQuote::setExchangeRate()
     * @uses ViewAARQuote::setExchangeRateDate()
     * @uses ViewAARQuote::setIATAStandardCodeType()
     * @uses ViewAARQuote::setLogicalFlightID()
     * @uses ViewAARQuote::setMarketingCarrier()
     * @uses ViewAARQuote::setMaxCountFlightLevel()
     * @uses ViewAARQuote::setMaxCountServiceLevel()
     * @uses ViewAARQuote::setOperatingCarrier()
     * @uses ViewAARQuote::setOriginalAmount()
     * @uses ViewAARQuote::setOriginalCurrency()
     * @uses ViewAARQuote::setPTCID()
     * @uses ViewAARQuote::setPhysicalFlightID()
     * @uses ViewAARQuote::setPriceAmountID()
     * @uses ViewAARQuote::setQuantityAvailable()
     * @uses ViewAARQuote::setRefundable()
     * @uses ViewAARQuote::setRevenueCategoryID()
     * @uses ViewAARQuote::setSSRCode()
     * @uses ViewAARQuote::setServiceActive()
     * @uses ViewAARQuote::setServiceID()
     * @uses ViewAARQuote::setStartSalesDays()
     * @uses ViewAARQuote::setPNLActive()
     * @uses ViewAARQuote::setServiceType()
     * @param float $amount
     * @param \ArrayType\ArrayOfApplicableTax $applicableTaxes
     * @param int $boardingPassSsrOrder
     * @param int $categoryID
     * @param bool $commissionable
     * @param string $currencyCode
     * @param int $cutoffHours
     * @param string $departureDate
     * @param string $description
     * @param bool $display
     * @param int $displayOrder
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     * @param string $iATAStandardCodeType
     * @param int $logicalFlightID
     * @param string $marketingCarrier
     * @param int $maxCountFlightLevel
     * @param int $maxCountServiceLevel
     * @param string $operatingCarrier
     * @param float $originalAmount
     * @param string $originalCurrency
     * @param int $pTCID
     * @param int $physicalFlightID
     * @param int $priceAmountID
     * @param int $quantityAvailable
     * @param bool $refundable
     * @param int $revenueCategoryID
     * @param string $sSRCode
     * @param bool $serviceActive
     * @param int $serviceID
     * @param int $startSalesDays
     * @param bool $pNLActive
     * @param int $serviceType
     */
    public function __construct($amount = null, \ArrayType\ArrayOfApplicableTax $applicableTaxes = null, $boardingPassSsrOrder = null, $categoryID = null, $commissionable = null, $currencyCode = null, $cutoffHours = null, $departureDate = null, $description = null, $display = null, $displayOrder = null, $exchangeRate = null, $exchangeRateDate = null, $iATAStandardCodeType = null, $logicalFlightID = null, $marketingCarrier = null, $maxCountFlightLevel = null, $maxCountServiceLevel = null, $operatingCarrier = null, $originalAmount = null, $originalCurrency = null, $pTCID = null, $physicalFlightID = null, $priceAmountID = null, $quantityAvailable = null, $refundable = null, $revenueCategoryID = null, $sSRCode = null, $serviceActive = null, $serviceID = null, $startSalesDays = null, $pNLActive = null, $serviceType = null)
    {
        $this
            ->setAmount($amount)
            ->setApplicableTaxes($applicableTaxes)
            ->setBoardingPassSsrOrder($boardingPassSsrOrder)
            ->setCategoryID($categoryID)
            ->setCommissionable($commissionable)
            ->setCurrencyCode($currencyCode)
            ->setCutoffHours($cutoffHours)
            ->setDepartureDate($departureDate)
            ->setDescription($description)
            ->setDisplay($display)
            ->setDisplayOrder($displayOrder)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate)
            ->setIATAStandardCodeType($iATAStandardCodeType)
            ->setLogicalFlightID($logicalFlightID)
            ->setMarketingCarrier($marketingCarrier)
            ->setMaxCountFlightLevel($maxCountFlightLevel)
            ->setMaxCountServiceLevel($maxCountServiceLevel)
            ->setOperatingCarrier($operatingCarrier)
            ->setOriginalAmount($originalAmount)
            ->setOriginalCurrency($originalCurrency)
            ->setPTCID($pTCID)
            ->setPhysicalFlightID($physicalFlightID)
            ->setPriceAmountID($priceAmountID)
            ->setQuantityAvailable($quantityAvailable)
            ->setRefundable($refundable)
            ->setRevenueCategoryID($revenueCategoryID)
            ->setSSRCode($sSRCode)
            ->setServiceActive($serviceActive)
            ->setServiceID($serviceID)
            ->setStartSalesDays($startSalesDays)
            ->setPNLActive($pNLActive)
            ->setServiceType($serviceType);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ViewAARQuote
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApplicableTaxes value
     * @return \ArrayType\ArrayOfApplicableTax|null
     */
    public function getApplicableTaxes()
    {
        return $this->ApplicableTaxes;
    }
    /**
     * Set ApplicableTaxes value
     * @param \ArrayType\ArrayOfApplicableTax $applicableTaxes
     * @return \StructType\ViewAARQuote
     */
    public function setApplicableTaxes(\ArrayType\ArrayOfApplicableTax $applicableTaxes = null)
    {
        $this->ApplicableTaxes = $applicableTaxes;
        return $this;
    }
    /**
     * Get BoardingPassSsrOrder value
     * @return int|null
     */
    public function getBoardingPassSsrOrder()
    {
        return $this->BoardingPassSsrOrder;
    }
    /**
     * Set BoardingPassSsrOrder value
     * @param int $boardingPassSsrOrder
     * @return \StructType\ViewAARQuote
     */
    public function setBoardingPassSsrOrder($boardingPassSsrOrder = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassSsrOrder) && !(is_int($boardingPassSsrOrder) || ctype_digit($boardingPassSsrOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassSsrOrder, true), gettype($boardingPassSsrOrder)), __LINE__);
        }
        $this->BoardingPassSsrOrder = $boardingPassSsrOrder;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \StructType\ViewAARQuote
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !(is_int($categoryID) || ctype_digit($categoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryID, true), gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return bool|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param bool $commissionable
     * @return \StructType\ViewAARQuote
     */
    public function setCommissionable($commissionable = null)
    {
        // validation for constraint: boolean
        if (!is_null($commissionable) && !is_bool($commissionable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commissionable, true), gettype($commissionable)), __LINE__);
        }
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\ViewAARQuote
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CutoffHours value
     * @return int|null
     */
    public function getCutoffHours()
    {
        return $this->CutoffHours;
    }
    /**
     * Set CutoffHours value
     * @param int $cutoffHours
     * @return \StructType\ViewAARQuote
     */
    public function setCutoffHours($cutoffHours = null)
    {
        // validation for constraint: int
        if (!is_null($cutoffHours) && !(is_int($cutoffHours) || ctype_digit($cutoffHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cutoffHours, true), gettype($cutoffHours)), __LINE__);
        }
        $this->CutoffHours = $cutoffHours;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ViewAARQuote
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ViewAARQuote
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Display value
     * @return bool|null
     */
    public function getDisplay()
    {
        return $this->Display;
    }
    /**
     * Set Display value
     * @param bool $display
     * @return \StructType\ViewAARQuote
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: boolean
        if (!is_null($display) && !is_bool($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        $this->Display = $display;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \StructType\ViewAARQuote
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !(is_int($displayOrder) || ctype_digit($displayOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayOrder, true), gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\ViewAARQuote
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\ViewAARQuote
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
    /**
     * Get IATAStandardCodeType value
     * @return string|null
     */
    public function getIATAStandardCodeType()
    {
        return $this->IATAStandardCodeType;
    }
    /**
     * Set IATAStandardCodeType value
     * @param string $iATAStandardCodeType
     * @return \StructType\ViewAARQuote
     */
    public function setIATAStandardCodeType($iATAStandardCodeType = null)
    {
        // validation for constraint: string
        if (!is_null($iATAStandardCodeType) && !is_string($iATAStandardCodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATAStandardCodeType, true), gettype($iATAStandardCodeType)), __LINE__);
        }
        $this->IATAStandardCodeType = $iATAStandardCodeType;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\ViewAARQuote
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return string|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param string $marketingCarrier
     * @return \StructType\ViewAARQuote
     */
    public function setMarketingCarrier($marketingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrier) && !is_string($marketingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrier, true), gettype($marketingCarrier)), __LINE__);
        }
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get MaxCountFlightLevel value
     * @return int|null
     */
    public function getMaxCountFlightLevel()
    {
        return $this->MaxCountFlightLevel;
    }
    /**
     * Set MaxCountFlightLevel value
     * @param int $maxCountFlightLevel
     * @return \StructType\ViewAARQuote
     */
    public function setMaxCountFlightLevel($maxCountFlightLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxCountFlightLevel) && !(is_int($maxCountFlightLevel) || ctype_digit($maxCountFlightLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCountFlightLevel, true), gettype($maxCountFlightLevel)), __LINE__);
        }
        $this->MaxCountFlightLevel = $maxCountFlightLevel;
        return $this;
    }
    /**
     * Get MaxCountServiceLevel value
     * @return int|null
     */
    public function getMaxCountServiceLevel()
    {
        return $this->MaxCountServiceLevel;
    }
    /**
     * Set MaxCountServiceLevel value
     * @param int $maxCountServiceLevel
     * @return \StructType\ViewAARQuote
     */
    public function setMaxCountServiceLevel($maxCountServiceLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxCountServiceLevel) && !(is_int($maxCountServiceLevel) || ctype_digit($maxCountServiceLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCountServiceLevel, true), gettype($maxCountServiceLevel)), __LINE__);
        }
        $this->MaxCountServiceLevel = $maxCountServiceLevel;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param string $operatingCarrier
     * @return \StructType\ViewAARQuote
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\ViewAARQuote
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\ViewAARQuote
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get PTCID value
     * @return int|null
     */
    public function getPTCID()
    {
        return $this->PTCID;
    }
    /**
     * Set PTCID value
     * @param int $pTCID
     * @return \StructType\ViewAARQuote
     */
    public function setPTCID($pTCID = null)
    {
        // validation for constraint: int
        if (!is_null($pTCID) && !(is_int($pTCID) || ctype_digit($pTCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCID, true), gettype($pTCID)), __LINE__);
        }
        $this->PTCID = $pTCID;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return isset($this->PhysicalFlightID) ? $this->PhysicalFlightID : null;
    }
    /**
     * Set PhysicalFlightID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $physicalFlightID
     * @return \StructType\ViewAARQuote
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        if (is_null($physicalFlightID) || (is_array($physicalFlightID) && empty($physicalFlightID))) {
            unset($this->PhysicalFlightID);
        } else {
            $this->PhysicalFlightID = $physicalFlightID;
        }
        return $this;
    }
    /**
     * Get PriceAmountID value
     * @return int|null
     */
    public function getPriceAmountID()
    {
        return $this->PriceAmountID;
    }
    /**
     * Set PriceAmountID value
     * @param int $priceAmountID
     * @return \StructType\ViewAARQuote
     */
    public function setPriceAmountID($priceAmountID = null)
    {
        // validation for constraint: int
        if (!is_null($priceAmountID) && !(is_int($priceAmountID) || ctype_digit($priceAmountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceAmountID, true), gettype($priceAmountID)), __LINE__);
        }
        $this->PriceAmountID = $priceAmountID;
        return $this;
    }
    /**
     * Get QuantityAvailable value
     * @return int|null
     */
    public function getQuantityAvailable()
    {
        return $this->QuantityAvailable;
    }
    /**
     * Set QuantityAvailable value
     * @param int $quantityAvailable
     * @return \StructType\ViewAARQuote
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAvailable) && !(is_int($quantityAvailable) || ctype_digit($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->QuantityAvailable = $quantityAvailable;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \StructType\ViewAARQuote
     */
    public function setRefundable($refundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundable) && !is_bool($refundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundable, true), gettype($refundable)), __LINE__);
        }
        $this->Refundable = $refundable;
        return $this;
    }
    /**
     * Get RevenueCategoryID value
     * @return int|null
     */
    public function getRevenueCategoryID()
    {
        return $this->RevenueCategoryID;
    }
    /**
     * Set RevenueCategoryID value
     * @param int $revenueCategoryID
     * @return \StructType\ViewAARQuote
     */
    public function setRevenueCategoryID($revenueCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($revenueCategoryID) && !(is_int($revenueCategoryID) || ctype_digit($revenueCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revenueCategoryID, true), gettype($revenueCategoryID)), __LINE__);
        }
        $this->RevenueCategoryID = $revenueCategoryID;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \StructType\ViewAARQuote
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSRCode, true), gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get ServiceActive value
     * @return bool|null
     */
    public function getServiceActive()
    {
        return $this->ServiceActive;
    }
    /**
     * Set ServiceActive value
     * @param bool $serviceActive
     * @return \StructType\ViewAARQuote
     */
    public function setServiceActive($serviceActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceActive) && !is_bool($serviceActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($serviceActive, true), gettype($serviceActive)), __LINE__);
        }
        $this->ServiceActive = $serviceActive;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return int|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param int $serviceID
     * @return \StructType\ViewAARQuote
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceID) && !(is_int($serviceID) || ctype_digit($serviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get StartSalesDays value
     * @return int|null
     */
    public function getStartSalesDays()
    {
        return $this->StartSalesDays;
    }
    /**
     * Set StartSalesDays value
     * @param int $startSalesDays
     * @return \StructType\ViewAARQuote
     */
    public function setStartSalesDays($startSalesDays = null)
    {
        // validation for constraint: int
        if (!is_null($startSalesDays) && !(is_int($startSalesDays) || ctype_digit($startSalesDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startSalesDays, true), gettype($startSalesDays)), __LINE__);
        }
        $this->StartSalesDays = $startSalesDays;
        return $this;
    }
    /**
     * Get PNLActive value
     * @return bool|null
     */
    public function getPNLActive()
    {
        return $this->PNLActive;
    }
    /**
     * Set PNLActive value
     * @param bool $pNLActive
     * @return \StructType\ViewAARQuote
     */
    public function setPNLActive($pNLActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($pNLActive) && !is_bool($pNLActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pNLActive, true), gettype($pNLActive)), __LINE__);
        }
        $this->PNLActive = $pNLActive;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return int|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param int $serviceType
     * @return \StructType\ViewAARQuote
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: int
        if (!is_null($serviceType) && !(is_int($serviceType) || ctype_digit($serviceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
}
