<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnFlightSegmentDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnFlightSegmentDetail
 * @subpackage Structs
 */
class ReturnFlightSegmentDetail extends AbstractStructBase
{
    /**
     * The LFID
     * @var int
     */
    public $LFID;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The LegCount
     * @var int
     */
    public $LegCount;
    /**
     * The FlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNum;
    /**
     * The FlightTime
     * @var float
     */
    public $FlightTime;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CarrierCode;
    /**
     * The International
     * @var bool
     */
    public $International;
    /**
     * The RoundTrip
     * @var bool
     */
    public $RoundTrip;
    /**
     * The FilterRemove
     * @var bool
     */
    public $FilterRemove;
    /**
     * The RetFareTypes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfRetFareType
     */
    public $RetFareTypes;
    /**
     * The FlightLegDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightLegDetail
     */
    public $FlightLegDetails;
    /**
     * Constructor method for ReturnFlightSegmentDetail
     * @uses ReturnFlightSegmentDetail::setLFID()
     * @uses ReturnFlightSegmentDetail::setOrigin()
     * @uses ReturnFlightSegmentDetail::setDestination()
     * @uses ReturnFlightSegmentDetail::setDepartureDate()
     * @uses ReturnFlightSegmentDetail::setLegCount()
     * @uses ReturnFlightSegmentDetail::setFlightNum()
     * @uses ReturnFlightSegmentDetail::setFlightTime()
     * @uses ReturnFlightSegmentDetail::setCarrierCode()
     * @uses ReturnFlightSegmentDetail::setInternational()
     * @uses ReturnFlightSegmentDetail::setRoundTrip()
     * @uses ReturnFlightSegmentDetail::setFilterRemove()
     * @uses ReturnFlightSegmentDetail::setRetFareTypes()
     * @uses ReturnFlightSegmentDetail::setFlightLegDetails()
     * @param int $lFID
     * @param string $origin
     * @param string $destination
     * @param string $departureDate
     * @param int $legCount
     * @param string $flightNum
     * @param float $flightTime
     * @param string $carrierCode
     * @param bool $international
     * @param bool $roundTrip
     * @param bool $filterRemove
     * @param \ArrayType\ArrayOfRetFareType $retFareTypes
     * @param \ArrayType\ArrayOfFlightLegDetail $flightLegDetails
     */
    public function __construct($lFID = null, $origin = null, $destination = null, $departureDate = null, $legCount = null, $flightNum = null, $flightTime = null, $carrierCode = null, $international = null, $roundTrip = null, $filterRemove = null, \ArrayType\ArrayOfRetFareType $retFareTypes = null, \ArrayType\ArrayOfFlightLegDetail $flightLegDetails = null)
    {
        $this
            ->setLFID($lFID)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setDepartureDate($departureDate)
            ->setLegCount($legCount)
            ->setFlightNum($flightNum)
            ->setFlightTime($flightTime)
            ->setCarrierCode($carrierCode)
            ->setInternational($international)
            ->setRoundTrip($roundTrip)
            ->setFilterRemove($filterRemove)
            ->setRetFareTypes($retFareTypes)
            ->setFlightLegDetails($flightLegDetails);
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get LegCount value
     * @return int|null
     */
    public function getLegCount()
    {
        return $this->LegCount;
    }
    /**
     * Set LegCount value
     * @param int $legCount
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setLegCount($legCount = null)
    {
        // validation for constraint: int
        if (!is_null($legCount) && !(is_int($legCount) || ctype_digit($legCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legCount, true), gettype($legCount)), __LINE__);
        }
        $this->LegCount = $legCount;
        return $this;
    }
    /**
     * Get FlightNum value
     * @return string|null
     */
    public function getFlightNum()
    {
        return $this->FlightNum;
    }
    /**
     * Set FlightNum value
     * @param string $flightNum
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setFlightNum($flightNum = null)
    {
        // validation for constraint: string
        if (!is_null($flightNum) && !is_string($flightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNum, true), gettype($flightNum)), __LINE__);
        }
        $this->FlightNum = $flightNum;
        return $this;
    }
    /**
     * Get FlightTime value
     * @return float|null
     */
    public function getFlightTime()
    {
        return $this->FlightTime;
    }
    /**
     * Set FlightTime value
     * @param float $flightTime
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setFlightTime($flightTime = null)
    {
        // validation for constraint: float
        if (!is_null($flightTime) && !(is_float($flightTime) || is_numeric($flightTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flightTime, true), gettype($flightTime)), __LINE__);
        }
        $this->FlightTime = $flightTime;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get International value
     * @return bool|null
     */
    public function getInternational()
    {
        return $this->International;
    }
    /**
     * Set International value
     * @param bool $international
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setInternational($international = null)
    {
        // validation for constraint: boolean
        if (!is_null($international) && !is_bool($international)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($international, true), gettype($international)), __LINE__);
        }
        $this->International = $international;
        return $this;
    }
    /**
     * Get RoundTrip value
     * @return bool|null
     */
    public function getRoundTrip()
    {
        return $this->RoundTrip;
    }
    /**
     * Set RoundTrip value
     * @param bool $roundTrip
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setRoundTrip($roundTrip = null)
    {
        // validation for constraint: boolean
        if (!is_null($roundTrip) && !is_bool($roundTrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($roundTrip, true), gettype($roundTrip)), __LINE__);
        }
        $this->RoundTrip = $roundTrip;
        return $this;
    }
    /**
     * Get FilterRemove value
     * @return bool|null
     */
    public function getFilterRemove()
    {
        return $this->FilterRemove;
    }
    /**
     * Set FilterRemove value
     * @param bool $filterRemove
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setFilterRemove($filterRemove = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterRemove) && !is_bool($filterRemove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterRemove, true), gettype($filterRemove)), __LINE__);
        }
        $this->FilterRemove = $filterRemove;
        return $this;
    }
    /**
     * Get RetFareTypes value
     * @return \ArrayType\ArrayOfRetFareType|null
     */
    public function getRetFareTypes()
    {
        return $this->RetFareTypes;
    }
    /**
     * Set RetFareTypes value
     * @param \ArrayType\ArrayOfRetFareType $retFareTypes
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setRetFareTypes(\ArrayType\ArrayOfRetFareType $retFareTypes = null)
    {
        $this->RetFareTypes = $retFareTypes;
        return $this;
    }
    /**
     * Get FlightLegDetails value
     * @return \ArrayType\ArrayOfFlightLegDetail|null
     */
    public function getFlightLegDetails()
    {
        return $this->FlightLegDetails;
    }
    /**
     * Set FlightLegDetails value
     * @param \ArrayType\ArrayOfFlightLegDetail $flightLegDetails
     * @return \StructType\ReturnFlightSegmentDetail
     */
    public function setFlightLegDetails(\ArrayType\ArrayOfFlightLegDetail $flightLegDetails = null)
    {
        $this->FlightLegDetails = $flightLegDetails;
        return $this;
    }
}
