<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSystemFareQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSystemFareQuote
 * @subpackage Structs
 */
class RetrieveSystemFareQuote extends RetrieveFareQuote
{
    /**
     * The RetrieveSystemFareQuoteRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSystemFareQuote
     */
    public $RetrieveSystemFareQuoteRequest;
    /**
     * The ReservationChannel
     * @var string
     */
    public $ReservationChannel;
    /**
     * Constructor method for RetrieveSystemFareQuote
     * @uses RetrieveSystemFareQuote::setRetrieveSystemFareQuoteRequest()
     * @uses RetrieveSystemFareQuote::setReservationChannel()
     * @param \StructType\RetrieveSystemFareQuote $retrieveSystemFareQuoteRequest
     * @param string $reservationChannel
     */
    public function __construct(\StructType\RetrieveSystemFareQuote $retrieveSystemFareQuoteRequest = null, $reservationChannel = null)
    {
        $this
            ->setRetrieveSystemFareQuoteRequest($retrieveSystemFareQuoteRequest)
            ->setReservationChannel($reservationChannel);
    }
    /**
     * Get RetrieveSystemFareQuoteRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSystemFareQuote|null
     */
    public function getRetrieveSystemFareQuoteRequest()
    {
        return isset($this->RetrieveSystemFareQuoteRequest) ? $this->RetrieveSystemFareQuoteRequest : null;
    }
    /**
     * Set RetrieveSystemFareQuoteRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSystemFareQuote $retrieveSystemFareQuoteRequest
     * @return \StructType\RetrieveSystemFareQuote
     */
    public function setRetrieveSystemFareQuoteRequest(\StructType\RetrieveSystemFareQuote $retrieveSystemFareQuoteRequest = null)
    {
        if (is_null($retrieveSystemFareQuoteRequest) || (is_array($retrieveSystemFareQuoteRequest) && empty($retrieveSystemFareQuoteRequest))) {
            unset($this->RetrieveSystemFareQuoteRequest);
        } else {
            $this->RetrieveSystemFareQuoteRequest = $retrieveSystemFareQuoteRequest;
        }
        return $this;
    }
    /**
     * Get ReservationChannel value
     * @return string|null
     */
    public function getReservationChannel()
    {
        return $this->ReservationChannel;
    }
    /**
     * Set ReservationChannel value
     * @uses \EnumType\Enumerations_ReservationChannelTypes::valueIsValid()
     * @uses \EnumType\Enumerations_ReservationChannelTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationChannel
     * @return \StructType\RetrieveSystemFareQuote
     */
    public function setReservationChannel($reservationChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_ReservationChannelTypes::valueIsValid($reservationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_ReservationChannelTypes', is_array($reservationChannel) ? implode(', ', $reservationChannel) : var_export($reservationChannel, true), implode(', ', \EnumType\Enumerations_ReservationChannelTypes::getValidValues())), __LINE__);
        }
        $this->ReservationChannel = $reservationChannel;
        return $this;
    }
}
