<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveServiceQuotesShop StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveServiceQuotesShop
 * @subpackage Structs
 */
class RetrieveServiceQuotesShop extends TransactionInfoNoSession
{
    /**
     * The IataNumberOfRequestor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IataNumberOfRequestor;
    /**
     * The IsRoundtrip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRoundtrip;
    /**
     * The RetrieveServiceQuotes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfServiceQuote
     */
    public $RetrieveServiceQuotes;
    /**
     * Constructor method for RetrieveServiceQuotesShop
     * @uses RetrieveServiceQuotesShop::setIataNumberOfRequestor()
     * @uses RetrieveServiceQuotesShop::setIsRoundtrip()
     * @uses RetrieveServiceQuotesShop::setRetrieveServiceQuotes()
     * @param string $iataNumberOfRequestor
     * @param bool $isRoundtrip
     * @param \ArrayType\ArrayOfServiceQuote $retrieveServiceQuotes
     */
    public function __construct($iataNumberOfRequestor = null, $isRoundtrip = null, \ArrayType\ArrayOfServiceQuote $retrieveServiceQuotes = null)
    {
        $this
            ->setIataNumberOfRequestor($iataNumberOfRequestor)
            ->setIsRoundtrip($isRoundtrip)
            ->setRetrieveServiceQuotes($retrieveServiceQuotes);
    }
    /**
     * Get IataNumberOfRequestor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIataNumberOfRequestor()
    {
        return isset($this->IataNumberOfRequestor) ? $this->IataNumberOfRequestor : null;
    }
    /**
     * Set IataNumberOfRequestor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iataNumberOfRequestor
     * @return \StructType\RetrieveServiceQuotesShop
     */
    public function setIataNumberOfRequestor($iataNumberOfRequestor = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumberOfRequestor) && !is_string($iataNumberOfRequestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataNumberOfRequestor, true), gettype($iataNumberOfRequestor)), __LINE__);
        }
        if (is_null($iataNumberOfRequestor) || (is_array($iataNumberOfRequestor) && empty($iataNumberOfRequestor))) {
            unset($this->IataNumberOfRequestor);
        } else {
            $this->IataNumberOfRequestor = $iataNumberOfRequestor;
        }
        return $this;
    }
    /**
     * Get IsRoundtrip value
     * @return bool|null
     */
    public function getIsRoundtrip()
    {
        return $this->IsRoundtrip;
    }
    /**
     * Set IsRoundtrip value
     * @param bool $isRoundtrip
     * @return \StructType\RetrieveServiceQuotesShop
     */
    public function setIsRoundtrip($isRoundtrip = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoundtrip) && !is_bool($isRoundtrip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoundtrip, true), gettype($isRoundtrip)), __LINE__);
        }
        $this->IsRoundtrip = $isRoundtrip;
        return $this;
    }
    /**
     * Get RetrieveServiceQuotes value
     * @return \ArrayType\ArrayOfServiceQuote|null
     */
    public function getRetrieveServiceQuotes()
    {
        return $this->RetrieveServiceQuotes;
    }
    /**
     * Set RetrieveServiceQuotes value
     * @param \ArrayType\ArrayOfServiceQuote $retrieveServiceQuotes
     * @return \StructType\RetrieveServiceQuotesShop
     */
    public function setRetrieveServiceQuotes(\ArrayType\ArrayOfServiceQuote $retrieveServiceQuotes = null)
    {
        $this->RetrieveServiceQuotes = $retrieveServiceQuotes;
        return $this;
    }
}
