<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveFareBundleDetailsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveFareBundleDetailsRequest
 * @subpackage Structs
 */
class RetrieveFareBundleDetailsRequest extends TransactionInfo
{
    /**
     * The BundleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BundleCode;
    /**
     * Constructor method for RetrieveFareBundleDetailsRequest
     * @uses RetrieveFareBundleDetailsRequest::setBundleCode()
     * @param string $bundleCode
     */
    public function __construct($bundleCode = null)
    {
        $this
            ->setBundleCode($bundleCode);
    }
    /**
     * Get BundleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleCode()
    {
        return isset($this->BundleCode) ? $this->BundleCode : null;
    }
    /**
     * Set BundleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleCode
     * @return \StructType\RetrieveFareBundleDetailsRequest
     */
    public function setBundleCode($bundleCode = null)
    {
        // validation for constraint: string
        if (!is_null($bundleCode) && !is_string($bundleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleCode, true), gettype($bundleCode)), __LINE__);
        }
        if (is_null($bundleCode) || (is_array($bundleCode) && empty($bundleCode))) {
            unset($this->BundleCode);
        } else {
            $this->BundleCode = $bundleCode;
        }
        return $this;
    }
}
