<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightSegment
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The LFID
     * @var int
     */
    public $LFID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The LegCount
     * @var int
     */
    public $LegCount;
    /**
     * The International
     * @var bool
     */
    public $International;
    /**
     * The FareTypes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFareType
     */
    public $FareTypes;
    /**
     * The FlightLegDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFlightLegDetail
     */
    public $FlightLegDetails;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setLFID()
     * @uses FlightSegment::setDepartureDate()
     * @uses FlightSegment::setArrivalDate()
     * @uses FlightSegment::setLegCount()
     * @uses FlightSegment::setInternational()
     * @uses FlightSegment::setFareTypes()
     * @uses FlightSegment::setFlightLegDetails()
     * @param int $lFID
     * @param string $departureDate
     * @param string $arrivalDate
     * @param int $legCount
     * @param bool $international
     * @param \ArrayType\ArrayOfFareType $fareTypes
     * @param \ArrayType\ArrayOfFlightLegDetail $flightLegDetails
     */
    public function __construct($lFID = null, $departureDate = null, $arrivalDate = null, $legCount = null, $international = null, \ArrayType\ArrayOfFareType $fareTypes = null, \ArrayType\ArrayOfFlightLegDetail $flightLegDetails = null)
    {
        $this
            ->setLFID($lFID)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setLegCount($legCount)
            ->setInternational($international)
            ->setFareTypes($fareTypes)
            ->setFlightLegDetails($flightLegDetails);
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\FlightSegment
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightSegment
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\FlightSegment
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get LegCount value
     * @return int|null
     */
    public function getLegCount()
    {
        return $this->LegCount;
    }
    /**
     * Set LegCount value
     * @param int $legCount
     * @return \StructType\FlightSegment
     */
    public function setLegCount($legCount = null)
    {
        // validation for constraint: int
        if (!is_null($legCount) && !(is_int($legCount) || ctype_digit($legCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legCount, true), gettype($legCount)), __LINE__);
        }
        $this->LegCount = $legCount;
        return $this;
    }
    /**
     * Get International value
     * @return bool|null
     */
    public function getInternational()
    {
        return $this->International;
    }
    /**
     * Set International value
     * @param bool $international
     * @return \StructType\FlightSegment
     */
    public function setInternational($international = null)
    {
        // validation for constraint: boolean
        if (!is_null($international) && !is_bool($international)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($international, true), gettype($international)), __LINE__);
        }
        $this->International = $international;
        return $this;
    }
    /**
     * Get FareTypes value
     * @return \ArrayType\ArrayOfFareType|null
     */
    public function getFareTypes()
    {
        return $this->FareTypes;
    }
    /**
     * Set FareTypes value
     * @param \ArrayType\ArrayOfFareType $fareTypes
     * @return \StructType\FlightSegment
     */
    public function setFareTypes(\ArrayType\ArrayOfFareType $fareTypes = null)
    {
        $this->FareTypes = $fareTypes;
        return $this;
    }
    /**
     * Get FlightLegDetails value
     * @return \ArrayType\ArrayOfFlightLegDetail|null
     */
    public function getFlightLegDetails()
    {
        return $this->FlightLegDetails;
    }
    /**
     * Set FlightLegDetails value
     * @param \ArrayType\ArrayOfFlightLegDetail $flightLegDetails
     * @return \StructType\FlightSegment
     */
    public function setFlightLegDetails(\ArrayType\ArrayOfFlightLegDetail $flightLegDetails = null)
    {
        $this->FlightLegDetails = $flightLegDetails;
        return $this;
    }
}
