<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightLegDetail
 * @subpackage Structs
 */
class FlightLegDetail extends AbstractStructBase
{
    /**
     * The PFID
     * @var int
     */
    public $PFID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * Constructor method for FlightLegDetail
     * @uses FlightLegDetail::setPFID()
     * @uses FlightLegDetail::setDepartureDate()
     * @param int $pFID
     * @param string $departureDate
     */
    public function __construct($pFID = null, $departureDate = null)
    {
        $this
            ->setPFID($pFID)
            ->setDepartureDate($departureDate);
    }
    /**
     * Get PFID value
     * @return int|null
     */
    public function getPFID()
    {
        return $this->PFID;
    }
    /**
     * Set PFID value
     * @param int $pFID
     * @return \StructType\FlightLegDetail
     */
    public function setPFID($pFID = null)
    {
        // validation for constraint: int
        if (!is_null($pFID) && !(is_int($pFID) || ctype_digit($pFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFID, true), gettype($pFID)), __LINE__);
        }
        $this->PFID = $pFID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightLegDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
}
