<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightDetail
 * @subpackage Structs
 */
class FlightDetail extends AbstractStructBase
{
    /**
     * The FlightDetailIdentifier
     * @var int
     */
    public $FlightDetailIdentifier;
    /**
     * The OriginLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationLocation;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The TotalFlightDuration
     * @var float
     */
    public $TotalFlightDuration;
    /**
     * The SeatsAvailable
     * @var int
     */
    public $SeatsAvailable;
    /**
     * The LegDetailIdentifiers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLegDetailIdentifier
     */
    public $LegDetailIdentifiers;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * Constructor method for FlightDetail
     * @uses FlightDetail::setFlightDetailIdentifier()
     * @uses FlightDetail::setOriginLocation()
     * @uses FlightDetail::setDestinationLocation()
     * @uses FlightDetail::setDepartureDate()
     * @uses FlightDetail::setArrivalDate()
     * @uses FlightDetail::setTotalFlightDuration()
     * @uses FlightDetail::setSeatsAvailable()
     * @uses FlightDetail::setLegDetailIdentifiers()
     * @uses FlightDetail::setLogicalFlightID()
     * @param int $flightDetailIdentifier
     * @param string $originLocation
     * @param string $destinationLocation
     * @param string $departureDate
     * @param string $arrivalDate
     * @param float $totalFlightDuration
     * @param int $seatsAvailable
     * @param \ArrayType\ArrayOfLegDetailIdentifier $legDetailIdentifiers
     * @param int $logicalFlightID
     */
    public function __construct($flightDetailIdentifier = null, $originLocation = null, $destinationLocation = null, $departureDate = null, $arrivalDate = null, $totalFlightDuration = null, $seatsAvailable = null, \ArrayType\ArrayOfLegDetailIdentifier $legDetailIdentifiers = null, $logicalFlightID = null)
    {
        $this
            ->setFlightDetailIdentifier($flightDetailIdentifier)
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setTotalFlightDuration($totalFlightDuration)
            ->setSeatsAvailable($seatsAvailable)
            ->setLegDetailIdentifiers($legDetailIdentifiers)
            ->setLogicalFlightID($logicalFlightID);
    }
    /**
     * Get FlightDetailIdentifier value
     * @return int|null
     */
    public function getFlightDetailIdentifier()
    {
        return $this->FlightDetailIdentifier;
    }
    /**
     * Set FlightDetailIdentifier value
     * @param int $flightDetailIdentifier
     * @return \StructType\FlightDetail
     */
    public function setFlightDetailIdentifier($flightDetailIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($flightDetailIdentifier) && !(is_int($flightDetailIdentifier) || ctype_digit($flightDetailIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightDetailIdentifier, true), gettype($flightDetailIdentifier)), __LINE__);
        }
        $this->FlightDetailIdentifier = $flightDetailIdentifier;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return string|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param string $originLocation
     * @return \StructType\FlightDetail
     */
    public function setOriginLocation($originLocation = null)
    {
        // validation for constraint: string
        if (!is_null($originLocation) && !is_string($originLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originLocation, true), gettype($originLocation)), __LINE__);
        }
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return string|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param string $destinationLocation
     * @return \StructType\FlightDetail
     */
    public function setDestinationLocation($destinationLocation = null)
    {
        // validation for constraint: string
        if (!is_null($destinationLocation) && !is_string($destinationLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationLocation, true), gettype($destinationLocation)), __LINE__);
        }
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\FlightDetail
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get TotalFlightDuration value
     * @return float|null
     */
    public function getTotalFlightDuration()
    {
        return $this->TotalFlightDuration;
    }
    /**
     * Set TotalFlightDuration value
     * @param float $totalFlightDuration
     * @return \StructType\FlightDetail
     */
    public function setTotalFlightDuration($totalFlightDuration = null)
    {
        // validation for constraint: float
        if (!is_null($totalFlightDuration) && !(is_float($totalFlightDuration) || is_numeric($totalFlightDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalFlightDuration, true), gettype($totalFlightDuration)), __LINE__);
        }
        $this->TotalFlightDuration = $totalFlightDuration;
        return $this;
    }
    /**
     * Get SeatsAvailable value
     * @return int|null
     */
    public function getSeatsAvailable()
    {
        return $this->SeatsAvailable;
    }
    /**
     * Set SeatsAvailable value
     * @param int $seatsAvailable
     * @return \StructType\FlightDetail
     */
    public function setSeatsAvailable($seatsAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($seatsAvailable) && !(is_int($seatsAvailable) || ctype_digit($seatsAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsAvailable, true), gettype($seatsAvailable)), __LINE__);
        }
        $this->SeatsAvailable = $seatsAvailable;
        return $this;
    }
    /**
     * Get LegDetailIdentifiers value
     * @return \ArrayType\ArrayOfLegDetailIdentifier|null
     */
    public function getLegDetailIdentifiers()
    {
        return $this->LegDetailIdentifiers;
    }
    /**
     * Set LegDetailIdentifiers value
     * @param \ArrayType\ArrayOfLegDetailIdentifier $legDetailIdentifiers
     * @return \StructType\FlightDetail
     */
    public function setLegDetailIdentifiers(\ArrayType\ArrayOfLegDetailIdentifier $legDetailIdentifiers = null)
    {
        $this->LegDetailIdentifiers = $legDetailIdentifiers;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\FlightDetail
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
}
