<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CombinableFlight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CombinableFlight
 * @subpackage Structs
 */
class CombinableFlight extends AbstractStructBase
{
    /**
     * The CombinableFareInfoDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCombinableFareInfo
     */
    public $CombinableFareInfoDetails;
    /**
     * The LFID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LFID;
    /**
     * Constructor method for CombinableFlight
     * @uses CombinableFlight::setCombinableFareInfoDetails()
     * @uses CombinableFlight::setLFID()
     * @param \ArrayType\ArrayOfCombinableFareInfo $combinableFareInfoDetails
     * @param int $lFID
     */
    public function __construct(\ArrayType\ArrayOfCombinableFareInfo $combinableFareInfoDetails = null, $lFID = null)
    {
        $this
            ->setCombinableFareInfoDetails($combinableFareInfoDetails)
            ->setLFID($lFID);
    }
    /**
     * Get CombinableFareInfoDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCombinableFareInfo|null
     */
    public function getCombinableFareInfoDetails()
    {
        return isset($this->CombinableFareInfoDetails) ? $this->CombinableFareInfoDetails : null;
    }
    /**
     * Set CombinableFareInfoDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCombinableFareInfo $combinableFareInfoDetails
     * @return \StructType\CombinableFlight
     */
    public function setCombinableFareInfoDetails(\ArrayType\ArrayOfCombinableFareInfo $combinableFareInfoDetails = null)
    {
        if (is_null($combinableFareInfoDetails) || (is_array($combinableFareInfoDetails) && empty($combinableFareInfoDetails))) {
            unset($this->CombinableFareInfoDetails);
        } else {
            $this->CombinableFareInfoDetails = $combinableFareInfoDetails;
        }
        return $this;
    }
    /**
     * Get LFID value
     * @return int|null
     */
    public function getLFID()
    {
        return $this->LFID;
    }
    /**
     * Set LFID value
     * @param int $lFID
     * @return \StructType\CombinableFlight
     */
    public function setLFID($lFID = null)
    {
        // validation for constraint: int
        if (!is_null($lFID) && !(is_int($lFID) || ctype_digit($lFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lFID, true), gettype($lFID)), __LINE__);
        }
        $this->LFID = $lFID;
        return $this;
    }
}
