<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicableTax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplicableTax
 * @subpackage Structs
 */
class ApplicableTax extends AbstractStructBase
{
    /**
     * The TaxID
     * @var int
     */
    public $TaxID;
    /**
     * The CodeType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeType;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxDescription;
    /**
     * The TaxType
     * @var string
     */
    public $TaxType;
    /**
     * The TaxAmount
     * @var float
     */
    public $TaxAmount;
    /**
     * The TaxCurrenyCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxCurrenyCode;
    /**
     * The AmountToApply
     * @var float
     */
    public $AmountToApply;
    /**
     * The TaxAmountType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TaxAmountType;
    /**
     * The IsDefault
     * @var bool
     */
    public $IsDefault;
    /**
     * The TaxActive
     * @var bool
     */
    public $TaxActive;
    /**
     * The MinAmount
     * @var float
     */
    public $MinAmount;
    /**
     * The MaxAmount
     * @var float
     */
    public $MaxAmount;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The OriginalCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalCurrency;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeRateDate;
    /**
     * Constructor method for ApplicableTax
     * @uses ApplicableTax::setTaxID()
     * @uses ApplicableTax::setCodeType()
     * @uses ApplicableTax::setTaxCode()
     * @uses ApplicableTax::setTaxDescription()
     * @uses ApplicableTax::setTaxType()
     * @uses ApplicableTax::setTaxAmount()
     * @uses ApplicableTax::setTaxCurrenyCode()
     * @uses ApplicableTax::setAmountToApply()
     * @uses ApplicableTax::setTaxAmountType()
     * @uses ApplicableTax::setIsDefault()
     * @uses ApplicableTax::setTaxActive()
     * @uses ApplicableTax::setMinAmount()
     * @uses ApplicableTax::setMaxAmount()
     * @uses ApplicableTax::setOriginalAmount()
     * @uses ApplicableTax::setOriginalCurrency()
     * @uses ApplicableTax::setExchangeRate()
     * @uses ApplicableTax::setExchangeRateDate()
     * @param int $taxID
     * @param string $codeType
     * @param string $taxCode
     * @param string $taxDescription
     * @param string $taxType
     * @param float $taxAmount
     * @param string $taxCurrenyCode
     * @param float $amountToApply
     * @param string $taxAmountType
     * @param bool $isDefault
     * @param bool $taxActive
     * @param float $minAmount
     * @param float $maxAmount
     * @param float $originalAmount
     * @param string $originalCurrency
     * @param float $exchangeRate
     * @param string $exchangeRateDate
     */
    public function __construct($taxID = null, $codeType = null, $taxCode = null, $taxDescription = null, $taxType = null, $taxAmount = null, $taxCurrenyCode = null, $amountToApply = null, $taxAmountType = null, $isDefault = null, $taxActive = null, $minAmount = null, $maxAmount = null, $originalAmount = null, $originalCurrency = null, $exchangeRate = null, $exchangeRateDate = null)
    {
        $this
            ->setTaxID($taxID)
            ->setCodeType($codeType)
            ->setTaxCode($taxCode)
            ->setTaxDescription($taxDescription)
            ->setTaxType($taxType)
            ->setTaxAmount($taxAmount)
            ->setTaxCurrenyCode($taxCurrenyCode)
            ->setAmountToApply($amountToApply)
            ->setTaxAmountType($taxAmountType)
            ->setIsDefault($isDefault)
            ->setTaxActive($taxActive)
            ->setMinAmount($minAmount)
            ->setMaxAmount($maxAmount)
            ->setOriginalAmount($originalAmount)
            ->setOriginalCurrency($originalCurrency)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateDate($exchangeRateDate);
    }
    /**
     * Get TaxID value
     * @return int|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param int $taxID
     * @return \StructType\ApplicableTax
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: int
        if (!is_null($taxID) && !(is_int($taxID) || ctype_digit($taxID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxID, true), gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get CodeType value
     * @return string|null
     */
    public function getCodeType()
    {
        return $this->CodeType;
    }
    /**
     * Set CodeType value
     * @param string $codeType
     * @return \StructType\ApplicableTax
     */
    public function setCodeType($codeType = null)
    {
        // validation for constraint: string
        if (!is_null($codeType) && !is_string($codeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeType, true), gettype($codeType)), __LINE__);
        }
        $this->CodeType = $codeType;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\ApplicableTax
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxDescription value
     * @return string|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * Set TaxDescription value
     * @param string $taxDescription
     * @return \StructType\ApplicableTax
     */
    public function setTaxDescription($taxDescription = null)
    {
        // validation for constraint: string
        if (!is_null($taxDescription) && !is_string($taxDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxDescription, true), gettype($taxDescription)), __LINE__);
        }
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @uses \EnumType\Enumerations_TaxTypes::valueIsValid()
     * @uses \EnumType\Enumerations_TaxTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxType
     * @return \StructType\ApplicableTax
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_TaxTypes::valueIsValid($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_TaxTypes', is_array($taxType) ? implode(', ', $taxType) : var_export($taxType, true), implode(', ', \EnumType\Enumerations_TaxTypes::getValidValues())), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\ApplicableTax
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxCurrenyCode value
     * @return string|null
     */
    public function getTaxCurrenyCode()
    {
        return $this->TaxCurrenyCode;
    }
    /**
     * Set TaxCurrenyCode value
     * @param string $taxCurrenyCode
     * @return \StructType\ApplicableTax
     */
    public function setTaxCurrenyCode($taxCurrenyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCurrenyCode) && !is_string($taxCurrenyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCurrenyCode, true), gettype($taxCurrenyCode)), __LINE__);
        }
        $this->TaxCurrenyCode = $taxCurrenyCode;
        return $this;
    }
    /**
     * Get AmountToApply value
     * @return float|null
     */
    public function getAmountToApply()
    {
        return $this->AmountToApply;
    }
    /**
     * Set AmountToApply value
     * @param float $amountToApply
     * @return \StructType\ApplicableTax
     */
    public function setAmountToApply($amountToApply = null)
    {
        // validation for constraint: float
        if (!is_null($amountToApply) && !(is_float($amountToApply) || is_numeric($amountToApply))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountToApply, true), gettype($amountToApply)), __LINE__);
        }
        $this->AmountToApply = $amountToApply;
        return $this;
    }
    /**
     * Get TaxAmountType value
     * @return string|null
     */
    public function getTaxAmountType()
    {
        return $this->TaxAmountType;
    }
    /**
     * Set TaxAmountType value
     * @param string $taxAmountType
     * @return \StructType\ApplicableTax
     */
    public function setTaxAmountType($taxAmountType = null)
    {
        // validation for constraint: string
        if (!is_null($taxAmountType) && !is_string($taxAmountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxAmountType, true), gettype($taxAmountType)), __LINE__);
        }
        $this->TaxAmountType = $taxAmountType;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\ApplicableTax
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get TaxActive value
     * @return bool|null
     */
    public function getTaxActive()
    {
        return $this->TaxActive;
    }
    /**
     * Set TaxActive value
     * @param bool $taxActive
     * @return \StructType\ApplicableTax
     */
    public function setTaxActive($taxActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxActive) && !is_bool($taxActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxActive, true), gettype($taxActive)), __LINE__);
        }
        $this->TaxActive = $taxActive;
        return $this;
    }
    /**
     * Get MinAmount value
     * @return float|null
     */
    public function getMinAmount()
    {
        return $this->MinAmount;
    }
    /**
     * Set MinAmount value
     * @param float $minAmount
     * @return \StructType\ApplicableTax
     */
    public function setMinAmount($minAmount = null)
    {
        // validation for constraint: float
        if (!is_null($minAmount) && !(is_float($minAmount) || is_numeric($minAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minAmount, true), gettype($minAmount)), __LINE__);
        }
        $this->MinAmount = $minAmount;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float|null
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ApplicableTax
     */
    public function setMaxAmount($maxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($maxAmount) && !(is_float($maxAmount) || is_numeric($maxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxAmount, true), gettype($maxAmount)), __LINE__);
        }
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\ApplicableTax
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get OriginalCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalCurrency()
    {
        return isset($this->OriginalCurrency) ? $this->OriginalCurrency : null;
    }
    /**
     * Set OriginalCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalCurrency
     * @return \StructType\ApplicableTax
     */
    public function setOriginalCurrency($originalCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originalCurrency) && !is_string($originalCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalCurrency, true), gettype($originalCurrency)), __LINE__);
        }
        if (is_null($originalCurrency) || (is_array($originalCurrency) && empty($originalCurrency))) {
            unset($this->OriginalCurrency);
        } else {
            $this->OriginalCurrency = $originalCurrency;
        }
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\ApplicableTax
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateDate value
     * @return string|null
     */
    public function getExchangeRateDate()
    {
        return $this->ExchangeRateDate;
    }
    /**
     * Set ExchangeRateDate value
     * @param string $exchangeRateDate
     * @return \StructType\ApplicableTax
     */
    public function setExchangeRateDate($exchangeRateDate = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateDate) && !is_string($exchangeRateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateDate, true), gettype($exchangeRateDate)), __LINE__);
        }
        $this->ExchangeRateDate = $exchangeRateDate;
        return $this;
    }
}
