<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AARQuote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AARQuote
 * @subpackage Structs
 */
class AARQuote extends AbstractStructBase
{
    /**
     * The AARRequestPtcs
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfAARRequestPtc
     */
    public $AARRequestPtcs;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirportCode;
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The DestinationAirportCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationAirportCode;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FareClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareClass;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The OperatingCarrierCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * The ServiceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ServiceTypes;
    /**
     * The UTCOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UTCOffset;
    /**
     * Constructor method for AARQuote
     * @uses AARQuote::setAARRequestPtcs()
     * @uses AARQuote::setAirportCode()
     * @uses AARQuote::setCabin()
     * @uses AARQuote::setCategory()
     * @uses AARQuote::setCurrency()
     * @uses AARQuote::setDepartureDate()
     * @uses AARQuote::setDestinationAirportCode()
     * @uses AARQuote::setFareBasisCode()
     * @uses AARQuote::setFareClass()
     * @uses AARQuote::setLogicalFlightID()
     * @uses AARQuote::setMarketingCarrierCode()
     * @uses AARQuote::setOperatingCarrierCode()
     * @uses AARQuote::setServiceCode()
     * @uses AARQuote::setServiceTypes()
     * @uses AARQuote::setUTCOffset()
     * @param \ArrayType\ArrayOfAARRequestPtc $aARRequestPtcs
     * @param string $airportCode
     * @param string $cabin
     * @param string $category
     * @param string $currency
     * @param string $departureDate
     * @param string $destinationAirportCode
     * @param string $fareBasisCode
     * @param string $fareClass
     * @param int $logicalFlightID
     * @param string $marketingCarrierCode
     * @param string $operatingCarrierCode
     * @param string $serviceCode
     * @param \ArrayType\ArrayOfint $serviceTypes
     * @param int $uTCOffset
     */
    public function __construct(\ArrayType\ArrayOfAARRequestPtc $aARRequestPtcs = null, $airportCode = null, $cabin = null, $category = null, $currency = null, $departureDate = null, $destinationAirportCode = null, $fareBasisCode = null, $fareClass = null, $logicalFlightID = null, $marketingCarrierCode = null, $operatingCarrierCode = null, $serviceCode = null, \ArrayType\ArrayOfint $serviceTypes = null, $uTCOffset = null)
    {
        $this
            ->setAARRequestPtcs($aARRequestPtcs)
            ->setAirportCode($airportCode)
            ->setCabin($cabin)
            ->setCategory($category)
            ->setCurrency($currency)
            ->setDepartureDate($departureDate)
            ->setDestinationAirportCode($destinationAirportCode)
            ->setFareBasisCode($fareBasisCode)
            ->setFareClass($fareClass)
            ->setLogicalFlightID($logicalFlightID)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setServiceCode($serviceCode)
            ->setServiceTypes($serviceTypes)
            ->setUTCOffset($uTCOffset);
    }
    /**
     * Get AARRequestPtcs value
     * @return \ArrayType\ArrayOfAARRequestPtc|null
     */
    public function getAARRequestPtcs()
    {
        return $this->AARRequestPtcs;
    }
    /**
     * Set AARRequestPtcs value
     * @param \ArrayType\ArrayOfAARRequestPtc $aARRequestPtcs
     * @return \StructType\AARQuote
     */
    public function setAARRequestPtcs(\ArrayType\ArrayOfAARRequestPtc $aARRequestPtcs = null)
    {
        $this->AARRequestPtcs = $aARRequestPtcs;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\AARQuote
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get Cabin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabin()
    {
        return isset($this->Cabin) ? $this->Cabin : null;
    }
    /**
     * Set Cabin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabin
     * @return \StructType\AARQuote
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        if (is_null($cabin) || (is_array($cabin) && empty($cabin))) {
            unset($this->Cabin);
        } else {
            $this->Cabin = $cabin;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \StructType\AARQuote
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\AARQuote
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\AARQuote
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DestinationAirportCode value
     * @return string|null
     */
    public function getDestinationAirportCode()
    {
        return $this->DestinationAirportCode;
    }
    /**
     * Set DestinationAirportCode value
     * @param string $destinationAirportCode
     * @return \StructType\AARQuote
     */
    public function setDestinationAirportCode($destinationAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportCode) && !is_string($destinationAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportCode, true), gettype($destinationAirportCode)), __LINE__);
        }
        $this->DestinationAirportCode = $destinationAirportCode;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \StructType\AARQuote
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get FareClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareClass()
    {
        return isset($this->FareClass) ? $this->FareClass : null;
    }
    /**
     * Set FareClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareClass
     * @return \StructType\AARQuote
     */
    public function setFareClass($fareClass = null)
    {
        // validation for constraint: string
        if (!is_null($fareClass) && !is_string($fareClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareClass, true), gettype($fareClass)), __LINE__);
        }
        if (is_null($fareClass) || (is_array($fareClass) && empty($fareClass))) {
            unset($this->FareClass);
        } else {
            $this->FareClass = $fareClass;
        }
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\AARQuote
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\AARQuote
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return isset($this->OperatingCarrierCode) ? $this->OperatingCarrierCode : null;
    }
    /**
     * Set OperatingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrierCode
     * @return \StructType\AARQuote
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierCode, true), gettype($operatingCarrierCode)), __LINE__);
        }
        if (is_null($operatingCarrierCode) || (is_array($operatingCarrierCode) && empty($operatingCarrierCode))) {
            unset($this->OperatingCarrierCode);
        } else {
            $this->OperatingCarrierCode = $operatingCarrierCode;
        }
        return $this;
    }
    /**
     * Get ServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceCode()
    {
        return isset($this->ServiceCode) ? $this->ServiceCode : null;
    }
    /**
     * Set ServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceCode
     * @return \StructType\AARQuote
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        if (is_null($serviceCode) || (is_array($serviceCode) && empty($serviceCode))) {
            unset($this->ServiceCode);
        } else {
            $this->ServiceCode = $serviceCode;
        }
        return $this;
    }
    /**
     * Get ServiceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getServiceTypes()
    {
        return isset($this->ServiceTypes) ? $this->ServiceTypes : null;
    }
    /**
     * Set ServiceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $serviceTypes
     * @return \StructType\AARQuote
     */
    public function setServiceTypes(\ArrayType\ArrayOfint $serviceTypes = null)
    {
        if (is_null($serviceTypes) || (is_array($serviceTypes) && empty($serviceTypes))) {
            unset($this->ServiceTypes);
        } else {
            $this->ServiceTypes = $serviceTypes;
        }
        return $this;
    }
    /**
     * Get UTCOffset value
     * @return int|null
     */
    public function getUTCOffset()
    {
        return $this->UTCOffset;
    }
    /**
     * Set UTCOffset value
     * @param int $uTCOffset
     * @return \StructType\AARQuote
     */
    public function setUTCOffset($uTCOffset = null)
    {
        // validation for constraint: int
        if (!is_null($uTCOffset) && !(is_int($uTCOffset) || ctype_digit($uTCOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uTCOffset, true), gettype($uTCOffset)), __LINE__);
        }
        $this->UTCOffset = $uTCOffset;
        return $this;
    }
}
