<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adjust ServiceType
 * @subpackage Services
 */
class Adjust extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AdjustFares
     * Meta information extracted from the WSDL
     * - documentation: <summary>Adjusts the relevant fares based on the supplied values - returns only fares being adjusted</summary> <param name="FarePriceAdjustmentRequest">payload to feed adjustment process.</param> <seealso cref="M:AdjustFaresShop()"
     * /> <seealso cref="M:AdjustFaresSession()" />
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdjustFares $parameters
     * @return \StructType\AdjustFaresResponse|bool
     */
    public function AdjustFares(\StructType\AdjustFares $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AdjustFares($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AdjustFaresShop
     * Meta information extracted from the WSDL
     * - documentation: <summary>Sessionless version of AdjustFares - returns only fares being adjusted</summary> <param name="FarePriceAdjustmentRequest">payload to feed adjustment process.</param> <seealso cref="M:AdjustFares()" /> <seealso
     * cref="M:AdjustFaresShop()" />
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdjustFaresShop $parameters
     * @return \StructType\AdjustFaresShopResponse|bool
     */
    public function AdjustFaresShop(\StructType\AdjustFaresShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AdjustFaresShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AdjustFaresSession
     * Meta information extracted from the WSDL
     * - documentation: <summary>Similar to AdjustFares except that it replaces the FareInformationId in session and returns a complete/session response</summary> <param name="FarePriceAdjustmentRequest">payload to feed adjustment process.</param> <seealso
     * cref="M:AdjustFares()" /> <seealso cref="M:AdjustFaresShop()" />
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdjustFaresSession $parameters
     * @return \StructType\AdjustFaresSessionResponse|bool
     */
    public function AdjustFaresSession(\StructType\AdjustFaresSession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AdjustFaresSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AdjustSpecialServices
     * Meta information extracted from the WSDL
     * - documentation: <summary> adjusts the relevant ssr information based on the supplied values. </summary> <param name="SpecialServiceAdjustmentRequest">payload to determine adjustments</param>
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AdjustSpecialServices $parameters
     * @return \StructType\AdjustSpecialServicesResponse|bool
     */
    public function AdjustSpecialServices(\StructType\AdjustSpecialServices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AdjustSpecialServices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AdjustFaresResponse|\StructType\AdjustFaresSessionResponse|\StructType\AdjustFaresShopResponse|\StructType\AdjustSpecialServicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
