<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTripInfo
 * @subpackage Arrays
 */
class ArrayOfTripInfo extends AbstractStructArrayBase
{
    /**
     * The TripInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripInfo[]
     */
    public $TripInfo;
    /**
     * Constructor method for ArrayOfTripInfo
     * @uses ArrayOfTripInfo::setTripInfo()
     * @param \StructType\TripInfo[] $tripInfo
     */
    public function __construct(array $tripInfo = array())
    {
        $this
            ->setTripInfo($tripInfo);
    }
    /**
     * Get TripInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripInfo[]|null
     */
    public function getTripInfo()
    {
        return isset($this->TripInfo) ? $this->TripInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTripInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripInfoForArrayConstraintsFromSetTripInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTripInfoTripInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTripInfoTripInfoItem instanceof \StructType\TripInfo) {
                $invalidValues[] = is_object($arrayOfTripInfoTripInfoItem) ? get_class($arrayOfTripInfoTripInfoItem) : sprintf('%s(%s)', gettype($arrayOfTripInfoTripInfoItem), var_export($arrayOfTripInfoTripInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripInfo property can only contain items of type \StructType\TripInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripInfo[] $tripInfo
     * @return \ArrayType\ArrayOfTripInfo
     */
    public function setTripInfo(array $tripInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($tripInfoArrayErrorMessage = self::validateTripInfoForArrayConstraintsFromSetTripInfo($tripInfo))) {
            throw new \InvalidArgumentException($tripInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($tripInfo) || (is_array($tripInfo) && empty($tripInfo))) {
            unset($this->TripInfo);
        } else {
            $this->TripInfo = $tripInfo;
        }
        return $this;
    }
    /**
     * Add item to TripInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TripInfo $item
     * @return \ArrayType\ArrayOfTripInfo
     */
    public function addToTripInfo(\StructType\TripInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripInfo) {
            throw new \InvalidArgumentException(sprintf('The TripInfo property can only contain items of type \StructType\TripInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripInfo
     */
    public function getAttributeName()
    {
        return 'TripInfo';
    }
}
