<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSecureFlightStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSecureFlightStatus
 * @subpackage Structs
 */
class RetrieveSecureFlightStatus extends TransactionInfo
{
    /**
     * The RetrieveSecureFlightStatusRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSecureFlightStatus
     */
    public $RetrieveSecureFlightStatusRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The PassengerFlightDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPassengerFlightDetail
     */
    public $PassengerFlightDetails;
    /**
     * Constructor method for RetrieveSecureFlightStatus
     * @uses RetrieveSecureFlightStatus::setRetrieveSecureFlightStatusRequest()
     * @uses RetrieveSecureFlightStatus::setReservationInfo()
     * @uses RetrieveSecureFlightStatus::setPassengerFlightDetails()
     * @param \StructType\RetrieveSecureFlightStatus $retrieveSecureFlightStatusRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfPassengerFlightDetail $passengerFlightDetails
     */
    public function __construct(\StructType\RetrieveSecureFlightStatus $retrieveSecureFlightStatusRequest = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfPassengerFlightDetail $passengerFlightDetails = null)
    {
        $this
            ->setRetrieveSecureFlightStatusRequest($retrieveSecureFlightStatusRequest)
            ->setReservationInfo($reservationInfo)
            ->setPassengerFlightDetails($passengerFlightDetails);
    }
    /**
     * Get RetrieveSecureFlightStatusRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSecureFlightStatus|null
     */
    public function getRetrieveSecureFlightStatusRequest()
    {
        return isset($this->RetrieveSecureFlightStatusRequest) ? $this->RetrieveSecureFlightStatusRequest : null;
    }
    /**
     * Set RetrieveSecureFlightStatusRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSecureFlightStatus $retrieveSecureFlightStatusRequest
     * @return \StructType\RetrieveSecureFlightStatus
     */
    public function setRetrieveSecureFlightStatusRequest(\StructType\RetrieveSecureFlightStatus $retrieveSecureFlightStatusRequest = null)
    {
        if (is_null($retrieveSecureFlightStatusRequest) || (is_array($retrieveSecureFlightStatusRequest) && empty($retrieveSecureFlightStatusRequest))) {
            unset($this->RetrieveSecureFlightStatusRequest);
        } else {
            $this->RetrieveSecureFlightStatusRequest = $retrieveSecureFlightStatusRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\RetrieveSecureFlightStatus
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get PassengerFlightDetails value
     * @return \ArrayType\ArrayOfPassengerFlightDetail|null
     */
    public function getPassengerFlightDetails()
    {
        return $this->PassengerFlightDetails;
    }
    /**
     * Set PassengerFlightDetails value
     * @param \ArrayType\ArrayOfPassengerFlightDetail $passengerFlightDetails
     * @return \StructType\RetrieveSecureFlightStatus
     */
    public function setPassengerFlightDetails(\ArrayType\ArrayOfPassengerFlightDetail $passengerFlightDetails = null)
    {
        $this->PassengerFlightDetails = $passengerFlightDetails;
        return $this;
    }
}
