<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerFlightStatusDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerFlightStatusDetail
 * @subpackage Structs
 */
class PassengerFlightStatusDetail extends AbstractStructBase
{
    /**
     * The PersonOrgID
     * @var int
     */
    public $PersonOrgID;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The TravelerClearanceStatus
     * @var string
     */
    public $TravelerClearanceStatus;
    /**
     * The EstaStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EstaStatus;
    /**
     * The EstaStatusDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EstaStatusDescription;
    /**
     * The ReferenceIdentifier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReferenceIdentifier;
    /**
     * The FirstContactDate
     * @var string
     */
    public $FirstContactDate;
    /**
     * The LastContactDate
     * @var string
     */
    public $LastContactDate;
    /**
     * The LastModifiedDate
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The PassengerDataVerified
     * @var bool
     */
    public $PassengerDataVerified;
    /**
     * Constructor method for PassengerFlightStatusDetail
     * @uses PassengerFlightStatusDetail::setPersonOrgID()
     * @uses PassengerFlightStatusDetail::setLogicalFlightID()
     * @uses PassengerFlightStatusDetail::setDepartureDate()
     * @uses PassengerFlightStatusDetail::setTravelerClearanceStatus()
     * @uses PassengerFlightStatusDetail::setEstaStatus()
     * @uses PassengerFlightStatusDetail::setEstaStatusDescription()
     * @uses PassengerFlightStatusDetail::setReferenceIdentifier()
     * @uses PassengerFlightStatusDetail::setFirstContactDate()
     * @uses PassengerFlightStatusDetail::setLastContactDate()
     * @uses PassengerFlightStatusDetail::setLastModifiedDate()
     * @uses PassengerFlightStatusDetail::setRecordLocator()
     * @uses PassengerFlightStatusDetail::setPassengerDataVerified()
     * @param int $personOrgID
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $travelerClearanceStatus
     * @param string $estaStatus
     * @param string $estaStatusDescription
     * @param string $referenceIdentifier
     * @param string $firstContactDate
     * @param string $lastContactDate
     * @param string $lastModifiedDate
     * @param string $recordLocator
     * @param bool $passengerDataVerified
     */
    public function __construct($personOrgID = null, $logicalFlightID = null, $departureDate = null, $travelerClearanceStatus = null, $estaStatus = null, $estaStatusDescription = null, $referenceIdentifier = null, $firstContactDate = null, $lastContactDate = null, $lastModifiedDate = null, $recordLocator = null, $passengerDataVerified = null)
    {
        $this
            ->setPersonOrgID($personOrgID)
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setTravelerClearanceStatus($travelerClearanceStatus)
            ->setEstaStatus($estaStatus)
            ->setEstaStatusDescription($estaStatusDescription)
            ->setReferenceIdentifier($referenceIdentifier)
            ->setFirstContactDate($firstContactDate)
            ->setLastContactDate($lastContactDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setRecordLocator($recordLocator)
            ->setPassengerDataVerified($passengerDataVerified);
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get TravelerClearanceStatus value
     * @return string|null
     */
    public function getTravelerClearanceStatus()
    {
        return $this->TravelerClearanceStatus;
    }
    /**
     * Set TravelerClearanceStatus value
     * @uses \EnumType\Enumerations_TravelerClearanceCodes::valueIsValid()
     * @uses \EnumType\Enumerations_TravelerClearanceCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelerClearanceStatus
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setTravelerClearanceStatus($travelerClearanceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_TravelerClearanceCodes::valueIsValid($travelerClearanceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_TravelerClearanceCodes', is_array($travelerClearanceStatus) ? implode(', ', $travelerClearanceStatus) : var_export($travelerClearanceStatus, true), implode(', ', \EnumType\Enumerations_TravelerClearanceCodes::getValidValues())), __LINE__);
        }
        $this->TravelerClearanceStatus = $travelerClearanceStatus;
        return $this;
    }
    /**
     * Get EstaStatus value
     * @return string|null
     */
    public function getEstaStatus()
    {
        return $this->EstaStatus;
    }
    /**
     * Set EstaStatus value
     * @param string $estaStatus
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setEstaStatus($estaStatus = null)
    {
        // validation for constraint: string
        if (!is_null($estaStatus) && !is_string($estaStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estaStatus, true), gettype($estaStatus)), __LINE__);
        }
        $this->EstaStatus = $estaStatus;
        return $this;
    }
    /**
     * Get EstaStatusDescription value
     * @return string|null
     */
    public function getEstaStatusDescription()
    {
        return $this->EstaStatusDescription;
    }
    /**
     * Set EstaStatusDescription value
     * @param string $estaStatusDescription
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setEstaStatusDescription($estaStatusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($estaStatusDescription) && !is_string($estaStatusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estaStatusDescription, true), gettype($estaStatusDescription)), __LINE__);
        }
        $this->EstaStatusDescription = $estaStatusDescription;
        return $this;
    }
    /**
     * Get ReferenceIdentifier value
     * @return string|null
     */
    public function getReferenceIdentifier()
    {
        return $this->ReferenceIdentifier;
    }
    /**
     * Set ReferenceIdentifier value
     * @param string $referenceIdentifier
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setReferenceIdentifier($referenceIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($referenceIdentifier) && !is_string($referenceIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceIdentifier, true), gettype($referenceIdentifier)), __LINE__);
        }
        $this->ReferenceIdentifier = $referenceIdentifier;
        return $this;
    }
    /**
     * Get FirstContactDate value
     * @return string|null
     */
    public function getFirstContactDate()
    {
        return $this->FirstContactDate;
    }
    /**
     * Set FirstContactDate value
     * @param string $firstContactDate
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setFirstContactDate($firstContactDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstContactDate) && !is_string($firstContactDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstContactDate, true), gettype($firstContactDate)), __LINE__);
        }
        $this->FirstContactDate = $firstContactDate;
        return $this;
    }
    /**
     * Get LastContactDate value
     * @return string|null
     */
    public function getLastContactDate()
    {
        return $this->LastContactDate;
    }
    /**
     * Set LastContactDate value
     * @param string $lastContactDate
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setLastContactDate($lastContactDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastContactDate) && !is_string($lastContactDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastContactDate, true), gettype($lastContactDate)), __LINE__);
        }
        $this->LastContactDate = $lastContactDate;
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get RecordLocator value
     * @return string|null
     */
    public function getRecordLocator()
    {
        return $this->RecordLocator;
    }
    /**
     * Set RecordLocator value
     * @param string $recordLocator
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        $this->RecordLocator = $recordLocator;
        return $this;
    }
    /**
     * Get PassengerDataVerified value
     * @return bool|null
     */
    public function getPassengerDataVerified()
    {
        return $this->PassengerDataVerified;
    }
    /**
     * Set PassengerDataVerified value
     * @param bool $passengerDataVerified
     * @return \StructType\PassengerFlightStatusDetail
     */
    public function setPassengerDataVerified($passengerDataVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($passengerDataVerified) && !is_bool($passengerDataVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passengerDataVerified, true), gettype($passengerDataVerified)), __LINE__);
        }
        $this->PassengerDataVerified = $passengerDataVerified;
        return $this;
    }
}
