<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationInfo
 * @subpackage Structs
 */
class ReservationInfo extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * Constructor method for ReservationInfo
     * @uses ReservationInfo::setSeriesNumber()
     * @uses ReservationInfo::setConfirmationNumber()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber);
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \StructType\ReservationInfo
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \StructType\ReservationInfo
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
}
