<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChangeNotice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingChangeNotice
 * @subpackage Structs
 */
class BookingChangeNotice extends AbstractStructBase
{
    /**
     * The DeliveryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryType;
    /**
     * The OverrideEmailAddresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Receipt
     */
    public $OverrideEmailAddresses;
    /**
     * The OverrideSmsNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReceiptSms
     */
    public $OverrideSmsNumbers;
    /**
     * The BookingActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingActionType;
    /**
     * The BookingSourceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingSourceType;
    /**
     * Constructor method for BookingChangeNotice
     * @uses BookingChangeNotice::setDeliveryType()
     * @uses BookingChangeNotice::setOverrideEmailAddresses()
     * @uses BookingChangeNotice::setOverrideSmsNumbers()
     * @uses BookingChangeNotice::setBookingActionType()
     * @uses BookingChangeNotice::setBookingSourceType()
     * @param string $deliveryType
     * @param \StructType\Receipt $overrideEmailAddresses
     * @param \StructType\ReceiptSms $overrideSmsNumbers
     * @param string $bookingActionType
     * @param string $bookingSourceType
     */
    public function __construct($deliveryType = null, \StructType\Receipt $overrideEmailAddresses = null, \StructType\ReceiptSms $overrideSmsNumbers = null, $bookingActionType = null, $bookingSourceType = null)
    {
        $this
            ->setDeliveryType($deliveryType)
            ->setOverrideEmailAddresses($overrideEmailAddresses)
            ->setOverrideSmsNumbers($overrideSmsNumbers)
            ->setBookingActionType($bookingActionType)
            ->setBookingSourceType($bookingSourceType);
    }
    /**
     * Get DeliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @uses \EnumType\Enumerations_Channels::valueIsValid()
     * @uses \EnumType\Enumerations_Channels::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryType
     * @return \StructType\BookingChangeNotice
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_Channels::valueIsValid($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_Channels', is_array($deliveryType) ? implode(', ', $deliveryType) : var_export($deliveryType, true), implode(', ', \EnumType\Enumerations_Channels::getValidValues())), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get OverrideEmailAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Receipt|null
     */
    public function getOverrideEmailAddresses()
    {
        return isset($this->OverrideEmailAddresses) ? $this->OverrideEmailAddresses : null;
    }
    /**
     * Set OverrideEmailAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Receipt $overrideEmailAddresses
     * @return \StructType\BookingChangeNotice
     */
    public function setOverrideEmailAddresses(\StructType\Receipt $overrideEmailAddresses = null)
    {
        if (is_null($overrideEmailAddresses) || (is_array($overrideEmailAddresses) && empty($overrideEmailAddresses))) {
            unset($this->OverrideEmailAddresses);
        } else {
            $this->OverrideEmailAddresses = $overrideEmailAddresses;
        }
        return $this;
    }
    /**
     * Get OverrideSmsNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReceiptSms|null
     */
    public function getOverrideSmsNumbers()
    {
        return isset($this->OverrideSmsNumbers) ? $this->OverrideSmsNumbers : null;
    }
    /**
     * Set OverrideSmsNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReceiptSms $overrideSmsNumbers
     * @return \StructType\BookingChangeNotice
     */
    public function setOverrideSmsNumbers(\StructType\ReceiptSms $overrideSmsNumbers = null)
    {
        if (is_null($overrideSmsNumbers) || (is_array($overrideSmsNumbers) && empty($overrideSmsNumbers))) {
            unset($this->OverrideSmsNumbers);
        } else {
            $this->OverrideSmsNumbers = $overrideSmsNumbers;
        }
        return $this;
    }
    /**
     * Get BookingActionType value
     * @return string|null
     */
    public function getBookingActionType()
    {
        return $this->BookingActionType;
    }
    /**
     * Set BookingActionType value
     * @uses \EnumType\Enumerations_BookingActionType::valueIsValid()
     * @uses \EnumType\Enumerations_BookingActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingActionType
     * @return \StructType\BookingChangeNotice
     */
    public function setBookingActionType($bookingActionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_BookingActionType::valueIsValid($bookingActionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_BookingActionType', is_array($bookingActionType) ? implode(', ', $bookingActionType) : var_export($bookingActionType, true), implode(', ', \EnumType\Enumerations_BookingActionType::getValidValues())), __LINE__);
        }
        $this->BookingActionType = $bookingActionType;
        return $this;
    }
    /**
     * Get BookingSourceType value
     * @return string|null
     */
    public function getBookingSourceType()
    {
        return $this->BookingSourceType;
    }
    /**
     * Set BookingSourceType value
     * @uses \EnumType\Enumerations_BookingSourceType::valueIsValid()
     * @uses \EnumType\Enumerations_BookingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingSourceType
     * @return \StructType\BookingChangeNotice
     */
    public function setBookingSourceType($bookingSourceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_BookingSourceType::valueIsValid($bookingSourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_BookingSourceType', is_array($bookingSourceType) ? implode(', ', $bookingSourceType) : var_export($bookingSourceType, true), implode(', ', \EnumType\Enumerations_BookingSourceType::getValidValues())), __LINE__);
        }
        $this->BookingSourceType = $bookingSourceType;
        return $this;
    }
}
