<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendNotification StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendNotification
 * @subpackage Structs
 */
class SendNotification extends TransactionInfo
{
    /**
     * The sendNotificationRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SendNotification
     */
    public $sendNotificationRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * The VoucherRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Voucher
     */
    public $VoucherRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ProfileRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Profile
     */
    public $ProfileRequest;
    /**
     * The ReceiptRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Receipt
     */
    public $ReceiptRequest;
    /**
     * The BookingChangeNoticeRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BookingChangeNotice
     */
    public $BookingChangeNoticeRequest;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * The NotificationSent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NotificationSent;
    /**
     * Constructor method for SendNotification
     * @uses SendNotification::setSendNotificationRequest()
     * @uses SendNotification::setActionType()
     * @uses SendNotification::setLanguageCode()
     * @uses SendNotification::setVoucherRequest()
     * @uses SendNotification::setReservationInfo()
     * @uses SendNotification::setProfileRequest()
     * @uses SendNotification::setReceiptRequest()
     * @uses SendNotification::setBookingChangeNoticeRequest()
     * @uses SendNotification::setExceptions()
     * @uses SendNotification::setNotificationSent()
     * @param \StructType\SendNotification $sendNotificationRequest
     * @param string $actionType
     * @param string $languageCode
     * @param \StructType\Voucher $voucherRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \StructType\Profile $profileRequest
     * @param \StructType\Receipt $receiptRequest
     * @param \StructType\BookingChangeNotice $bookingChangeNoticeRequest
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @param bool $notificationSent
     */
    public function __construct(\StructType\SendNotification $sendNotificationRequest = null, $actionType = null, $languageCode = null, \StructType\Voucher $voucherRequest = null, \StructType\ReservationInfo $reservationInfo = null, \StructType\Profile $profileRequest = null, \StructType\Receipt $receiptRequest = null, \StructType\BookingChangeNotice $bookingChangeNoticeRequest = null, \StructType\ExceptionInformation_Exceptions $exceptions = null, $notificationSent = null)
    {
        $this
            ->setSendNotificationRequest($sendNotificationRequest)
            ->setActionType($actionType)
            ->setLanguageCode($languageCode)
            ->setVoucherRequest($voucherRequest)
            ->setReservationInfo($reservationInfo)
            ->setProfileRequest($profileRequest)
            ->setReceiptRequest($receiptRequest)
            ->setBookingChangeNoticeRequest($bookingChangeNoticeRequest)
            ->setExceptions($exceptions)
            ->setNotificationSent($notificationSent);
    }
    /**
     * Get sendNotificationRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SendNotification|null
     */
    public function getSendNotificationRequest()
    {
        return isset($this->sendNotificationRequest) ? $this->sendNotificationRequest : null;
    }
    /**
     * Set sendNotificationRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SendNotification $sendNotificationRequest
     * @return \StructType\SendNotification
     */
    public function setSendNotificationRequest(\StructType\SendNotification $sendNotificationRequest = null)
    {
        if (is_null($sendNotificationRequest) || (is_array($sendNotificationRequest) && empty($sendNotificationRequest))) {
            unset($this->sendNotificationRequest);
        } else {
            $this->sendNotificationRequest = $sendNotificationRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\SendNotification_ActionTypes::valueIsValid()
     * @uses \EnumType\SendNotification_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\SendNotification
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SendNotification_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SendNotification_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\SendNotification_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\SendNotification
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get VoucherRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Voucher|null
     */
    public function getVoucherRequest()
    {
        return isset($this->VoucherRequest) ? $this->VoucherRequest : null;
    }
    /**
     * Set VoucherRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Voucher $voucherRequest
     * @return \StructType\SendNotification
     */
    public function setVoucherRequest(\StructType\Voucher $voucherRequest = null)
    {
        if (is_null($voucherRequest) || (is_array($voucherRequest) && empty($voucherRequest))) {
            unset($this->VoucherRequest);
        } else {
            $this->VoucherRequest = $voucherRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\SendNotification
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ProfileRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Profile|null
     */
    public function getProfileRequest()
    {
        return isset($this->ProfileRequest) ? $this->ProfileRequest : null;
    }
    /**
     * Set ProfileRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Profile $profileRequest
     * @return \StructType\SendNotification
     */
    public function setProfileRequest(\StructType\Profile $profileRequest = null)
    {
        if (is_null($profileRequest) || (is_array($profileRequest) && empty($profileRequest))) {
            unset($this->ProfileRequest);
        } else {
            $this->ProfileRequest = $profileRequest;
        }
        return $this;
    }
    /**
     * Get ReceiptRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Receipt|null
     */
    public function getReceiptRequest()
    {
        return isset($this->ReceiptRequest) ? $this->ReceiptRequest : null;
    }
    /**
     * Set ReceiptRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Receipt $receiptRequest
     * @return \StructType\SendNotification
     */
    public function setReceiptRequest(\StructType\Receipt $receiptRequest = null)
    {
        if (is_null($receiptRequest) || (is_array($receiptRequest) && empty($receiptRequest))) {
            unset($this->ReceiptRequest);
        } else {
            $this->ReceiptRequest = $receiptRequest;
        }
        return $this;
    }
    /**
     * Get BookingChangeNoticeRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BookingChangeNotice|null
     */
    public function getBookingChangeNoticeRequest()
    {
        return isset($this->BookingChangeNoticeRequest) ? $this->BookingChangeNoticeRequest : null;
    }
    /**
     * Set BookingChangeNoticeRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BookingChangeNotice $bookingChangeNoticeRequest
     * @return \StructType\SendNotification
     */
    public function setBookingChangeNoticeRequest(\StructType\BookingChangeNotice $bookingChangeNoticeRequest = null)
    {
        if (is_null($bookingChangeNoticeRequest) || (is_array($bookingChangeNoticeRequest) && empty($bookingChangeNoticeRequest))) {
            unset($this->BookingChangeNoticeRequest);
        } else {
            $this->BookingChangeNoticeRequest = $bookingChangeNoticeRequest;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\SendNotification
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
    /**
     * Get NotificationSent value
     * @return bool|null
     */
    public function getNotificationSent()
    {
        return $this->NotificationSent;
    }
    /**
     * Set NotificationSent value
     * @param bool $notificationSent
     * @return \StructType\SendNotification
     */
    public function setNotificationSent($notificationSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificationSent) && !is_bool($notificationSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificationSent, true), gettype($notificationSent)), __LINE__);
        }
        $this->NotificationSent = $notificationSent;
        return $this;
    }
}
