<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Fulfillment.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Fulfillment.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for ProcessPNRPayment operation/method
 */
if ($process->ProcessPNRPayment(new \StructType\ProcessPNRPayment()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessItemPayment operation/method
 */
if ($process->ProcessItemPayment(new \StructType\ProcessItemPayment()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for InsertExternalProcessedPayment operation/method
 */
if ($insert->InsertExternalProcessedPayment(new \StructType\InsertExternalProcessedPayment()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Format ServiceType
 */
$format = new \ServiceType\Format($options);
/**
 * Sample call for Format3DSecureInformation operation/method
 */
if ($format->Format3DSecureInformation(new \StructType\Format3DSecureInformation()) !== false) {
    print_r($format->getResult());
} else {
    print_r($format->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateExternalProcessedPayment operation/method
 */
if ($update->UpdateExternalProcessedPayment(new \StructType\UpdateExternalProcessedPayment()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketingTimeLimit operation/method
 */
if ($update->UpdateTicketingTimeLimit(new \StructType\UpdateTicketingTimeLimit()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateExternalProcessedPaymentDetails operation/method
 */
if ($update->UpdateExternalProcessedPaymentDetails(new \StructType\UpdateExternalProcessedPaymentDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \ServiceType\Convert($options);
/**
 * Sample call for ConvertCurrencies operation/method
 */
if ($convert->ConvertCurrencies(new \StructType\ConvertCurrencies()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddVoucherToReservation operation/method
 */
if ($add->AddVoucherToReservation(new \StructType\AddVoucherToReservation()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPointsToReservation operation/method
 */
if ($add->AddPointsToReservation(new \StructType\AddPointsToReservation()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemoveVoucherFromReservationInSession operation/method
 */
if ($remove->RemoveVoucherFromReservationInSession(new \StructType\RemoveVoucherFromReservationInSession()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetConvertedReservationBalance operation/method
 */
if ($get->GetConvertedReservationBalance(new \StructType\GetConvertedReservationBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
