<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Voucher
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherNumber;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The SeriesNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNum;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The ChargeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChargeNumber;
    /**
     * The Sponsor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sponsor;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OriginalAmount;
    /**
     * The BalanceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BalanceAmount;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The NonTransferable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NonTransferable;
    /**
     * The BatchProcessStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BatchProcessStart;
    /**
     * The BatchProcessExtracted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BatchProcessExtracted;
    /**
     * The VoucherType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherType;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TripType;
    /**
     * The IncludeTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncludeTaxes;
    /**
     * The IncludePenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncludePenalty;
    /**
     * The IncludeSSR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncludeSSR;
    /**
     * The IncludeAuto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncludeAuto;
    /**
     * The IncludeHotel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncludeHotel;
    /**
     * The STimeRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STimeRestrict;
    /**
     * The ETimeRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ETimeRestrict;
    /**
     * The SundayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SundayRestrict;
    /**
     * The MondayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MondayRestrict;
    /**
     * The TuesdayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TuesdayRestrict;
    /**
     * The WednesdayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WednesdayRestrict;
    /**
     * The ThursdayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ThursdayRestrict;
    /**
     * The FridayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FridayRestrict;
    /**
     * The SaturdayRestrict
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SaturdayRestrict;
    /**
     * The VoucherNumFull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherNumFull;
    /**
     * The VoucherPW
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherPW;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The TravelEffectiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelEffectiveDate;
    /**
     * The TravelExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravelExpirationDate;
    /**
     * The LogicalFlightsKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogicalFlightsKey;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setKey()
     * @uses Voucher::setVoucherNumber()
     * @uses Voucher::setCurrencyCode()
     * @uses Voucher::setReasonCode()
     * @uses Voucher::setPersonOrgID()
     * @uses Voucher::setSeriesNum()
     * @uses Voucher::setConfirmationNumber()
     * @uses Voucher::setRecordNumber()
     * @uses Voucher::setChargeNumber()
     * @uses Voucher::setSponsor()
     * @uses Voucher::setCreateDate()
     * @uses Voucher::setEffectiveDate()
     * @uses Voucher::setExpirationDate()
     * @uses Voucher::setOriginalAmount()
     * @uses Voucher::setBalanceAmount()
     * @uses Voucher::setUserId()
     * @uses Voucher::setNonTransferable()
     * @uses Voucher::setBatchProcessStart()
     * @uses Voucher::setBatchProcessExtracted()
     * @uses Voucher::setVoucherType()
     * @uses Voucher::setTripType()
     * @uses Voucher::setIncludeTaxes()
     * @uses Voucher::setIncludePenalty()
     * @uses Voucher::setIncludeSSR()
     * @uses Voucher::setIncludeAuto()
     * @uses Voucher::setIncludeHotel()
     * @uses Voucher::setSTimeRestrict()
     * @uses Voucher::setETimeRestrict()
     * @uses Voucher::setSundayRestrict()
     * @uses Voucher::setMondayRestrict()
     * @uses Voucher::setTuesdayRestrict()
     * @uses Voucher::setWednesdayRestrict()
     * @uses Voucher::setThursdayRestrict()
     * @uses Voucher::setFridayRestrict()
     * @uses Voucher::setSaturdayRestrict()
     * @uses Voucher::setVoucherNumFull()
     * @uses Voucher::setVoucherPW()
     * @uses Voucher::setFirstName()
     * @uses Voucher::setLastName()
     * @uses Voucher::setTravelEffectiveDate()
     * @uses Voucher::setTravelExpirationDate()
     * @uses Voucher::setLogicalFlightsKey()
     * @param string $key
     * @param int $voucherNumber
     * @param string $currencyCode
     * @param string $reasonCode
     * @param int $personOrgID
     * @param string $seriesNum
     * @param string $confirmationNumber
     * @param int $recordNumber
     * @param int $chargeNumber
     * @param string $sponsor
     * @param string $createDate
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param float $originalAmount
     * @param float $balanceAmount
     * @param string $userId
     * @param int $nonTransferable
     * @param string $batchProcessStart
     * @param int $batchProcessExtracted
     * @param int $voucherType
     * @param int $tripType
     * @param int $includeTaxes
     * @param int $includePenalty
     * @param int $includeSSR
     * @param int $includeAuto
     * @param int $includeHotel
     * @param string $sTimeRestrict
     * @param string $eTimeRestrict
     * @param int $sundayRestrict
     * @param int $mondayRestrict
     * @param int $tuesdayRestrict
     * @param int $wednesdayRestrict
     * @param int $thursdayRestrict
     * @param int $fridayRestrict
     * @param int $saturdayRestrict
     * @param string $voucherNumFull
     * @param string $voucherPW
     * @param string $firstName
     * @param string $lastName
     * @param string $travelEffectiveDate
     * @param string $travelExpirationDate
     * @param string $logicalFlightsKey
     */
    public function __construct($key = null, $voucherNumber = null, $currencyCode = null, $reasonCode = null, $personOrgID = null, $seriesNum = null, $confirmationNumber = null, $recordNumber = null, $chargeNumber = null, $sponsor = null, $createDate = null, $effectiveDate = null, $expirationDate = null, $originalAmount = null, $balanceAmount = null, $userId = null, $nonTransferable = null, $batchProcessStart = null, $batchProcessExtracted = null, $voucherType = null, $tripType = null, $includeTaxes = null, $includePenalty = null, $includeSSR = null, $includeAuto = null, $includeHotel = null, $sTimeRestrict = null, $eTimeRestrict = null, $sundayRestrict = null, $mondayRestrict = null, $tuesdayRestrict = null, $wednesdayRestrict = null, $thursdayRestrict = null, $fridayRestrict = null, $saturdayRestrict = null, $voucherNumFull = null, $voucherPW = null, $firstName = null, $lastName = null, $travelEffectiveDate = null, $travelExpirationDate = null, $logicalFlightsKey = null)
    {
        $this
            ->setKey($key)
            ->setVoucherNumber($voucherNumber)
            ->setCurrencyCode($currencyCode)
            ->setReasonCode($reasonCode)
            ->setPersonOrgID($personOrgID)
            ->setSeriesNum($seriesNum)
            ->setConfirmationNumber($confirmationNumber)
            ->setRecordNumber($recordNumber)
            ->setChargeNumber($chargeNumber)
            ->setSponsor($sponsor)
            ->setCreateDate($createDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setOriginalAmount($originalAmount)
            ->setBalanceAmount($balanceAmount)
            ->setUserId($userId)
            ->setNonTransferable($nonTransferable)
            ->setBatchProcessStart($batchProcessStart)
            ->setBatchProcessExtracted($batchProcessExtracted)
            ->setVoucherType($voucherType)
            ->setTripType($tripType)
            ->setIncludeTaxes($includeTaxes)
            ->setIncludePenalty($includePenalty)
            ->setIncludeSSR($includeSSR)
            ->setIncludeAuto($includeAuto)
            ->setIncludeHotel($includeHotel)
            ->setSTimeRestrict($sTimeRestrict)
            ->setETimeRestrict($eTimeRestrict)
            ->setSundayRestrict($sundayRestrict)
            ->setMondayRestrict($mondayRestrict)
            ->setTuesdayRestrict($tuesdayRestrict)
            ->setWednesdayRestrict($wednesdayRestrict)
            ->setThursdayRestrict($thursdayRestrict)
            ->setFridayRestrict($fridayRestrict)
            ->setSaturdayRestrict($saturdayRestrict)
            ->setVoucherNumFull($voucherNumFull)
            ->setVoucherPW($voucherPW)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setTravelEffectiveDate($travelEffectiveDate)
            ->setTravelExpirationDate($travelExpirationDate)
            ->setLogicalFlightsKey($logicalFlightsKey);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\Voucher
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param int $voucherNumber
     * @return \StructType\Voucher
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\Voucher
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \StructType\Voucher
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\Voucher
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get SeriesNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNum()
    {
        return isset($this->SeriesNum) ? $this->SeriesNum : null;
    }
    /**
     * Set SeriesNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNum
     * @return \StructType\Voucher
     */
    public function setSeriesNum($seriesNum = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNum) && !is_string($seriesNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNum, true), gettype($seriesNum)), __LINE__);
        }
        if (is_null($seriesNum) || (is_array($seriesNum) && empty($seriesNum))) {
            unset($this->SeriesNum);
        } else {
            $this->SeriesNum = $seriesNum;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\Voucher
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\Voucher
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get ChargeNumber value
     * @return int|null
     */
    public function getChargeNumber()
    {
        return $this->ChargeNumber;
    }
    /**
     * Set ChargeNumber value
     * @param int $chargeNumber
     * @return \StructType\Voucher
     */
    public function setChargeNumber($chargeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($chargeNumber) && !(is_int($chargeNumber) || ctype_digit($chargeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeNumber, true), gettype($chargeNumber)), __LINE__);
        }
        $this->ChargeNumber = $chargeNumber;
        return $this;
    }
    /**
     * Get Sponsor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSponsor()
    {
        return isset($this->Sponsor) ? $this->Sponsor : null;
    }
    /**
     * Set Sponsor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sponsor
     * @return \StructType\Voucher
     */
    public function setSponsor($sponsor = null)
    {
        // validation for constraint: string
        if (!is_null($sponsor) && !is_string($sponsor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sponsor, true), gettype($sponsor)), __LINE__);
        }
        if (is_null($sponsor) || (is_array($sponsor) && empty($sponsor))) {
            unset($this->Sponsor);
        } else {
            $this->Sponsor = $sponsor;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Voucher
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Voucher
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Voucher
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param float $originalAmount
     * @return \StructType\Voucher
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get BalanceAmount value
     * @return float|null
     */
    public function getBalanceAmount()
    {
        return $this->BalanceAmount;
    }
    /**
     * Set BalanceAmount value
     * @param float $balanceAmount
     * @return \StructType\Voucher
     */
    public function setBalanceAmount($balanceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($balanceAmount) && !(is_float($balanceAmount) || is_numeric($balanceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balanceAmount, true), gettype($balanceAmount)), __LINE__);
        }
        $this->BalanceAmount = $balanceAmount;
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \StructType\Voucher
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get NonTransferable value
     * @return int|null
     */
    public function getNonTransferable()
    {
        return $this->NonTransferable;
    }
    /**
     * Set NonTransferable value
     * @param int $nonTransferable
     * @return \StructType\Voucher
     */
    public function setNonTransferable($nonTransferable = null)
    {
        // validation for constraint: int
        if (!is_null($nonTransferable) && !(is_int($nonTransferable) || ctype_digit($nonTransferable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonTransferable, true), gettype($nonTransferable)), __LINE__);
        }
        $this->NonTransferable = $nonTransferable;
        return $this;
    }
    /**
     * Get BatchProcessStart value
     * @return string|null
     */
    public function getBatchProcessStart()
    {
        return $this->BatchProcessStart;
    }
    /**
     * Set BatchProcessStart value
     * @param string $batchProcessStart
     * @return \StructType\Voucher
     */
    public function setBatchProcessStart($batchProcessStart = null)
    {
        // validation for constraint: string
        if (!is_null($batchProcessStart) && !is_string($batchProcessStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchProcessStart, true), gettype($batchProcessStart)), __LINE__);
        }
        $this->BatchProcessStart = $batchProcessStart;
        return $this;
    }
    /**
     * Get BatchProcessExtracted value
     * @return int|null
     */
    public function getBatchProcessExtracted()
    {
        return $this->BatchProcessExtracted;
    }
    /**
     * Set BatchProcessExtracted value
     * @param int $batchProcessExtracted
     * @return \StructType\Voucher
     */
    public function setBatchProcessExtracted($batchProcessExtracted = null)
    {
        // validation for constraint: int
        if (!is_null($batchProcessExtracted) && !(is_int($batchProcessExtracted) || ctype_digit($batchProcessExtracted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchProcessExtracted, true), gettype($batchProcessExtracted)), __LINE__);
        }
        $this->BatchProcessExtracted = $batchProcessExtracted;
        return $this;
    }
    /**
     * Get VoucherType value
     * @return int|null
     */
    public function getVoucherType()
    {
        return $this->VoucherType;
    }
    /**
     * Set VoucherType value
     * @param int $voucherType
     * @return \StructType\Voucher
     */
    public function setVoucherType($voucherType = null)
    {
        // validation for constraint: int
        if (!is_null($voucherType) && !(is_int($voucherType) || ctype_digit($voucherType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherType, true), gettype($voucherType)), __LINE__);
        }
        $this->VoucherType = $voucherType;
        return $this;
    }
    /**
     * Get TripType value
     * @return int|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @param int $tripType
     * @return \StructType\Voucher
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: int
        if (!is_null($tripType) && !(is_int($tripType) || ctype_digit($tripType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripType, true), gettype($tripType)), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get IncludeTaxes value
     * @return int|null
     */
    public function getIncludeTaxes()
    {
        return $this->IncludeTaxes;
    }
    /**
     * Set IncludeTaxes value
     * @param int $includeTaxes
     * @return \StructType\Voucher
     */
    public function setIncludeTaxes($includeTaxes = null)
    {
        // validation for constraint: int
        if (!is_null($includeTaxes) && !(is_int($includeTaxes) || ctype_digit($includeTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includeTaxes, true), gettype($includeTaxes)), __LINE__);
        }
        $this->IncludeTaxes = $includeTaxes;
        return $this;
    }
    /**
     * Get IncludePenalty value
     * @return int|null
     */
    public function getIncludePenalty()
    {
        return $this->IncludePenalty;
    }
    /**
     * Set IncludePenalty value
     * @param int $includePenalty
     * @return \StructType\Voucher
     */
    public function setIncludePenalty($includePenalty = null)
    {
        // validation for constraint: int
        if (!is_null($includePenalty) && !(is_int($includePenalty) || ctype_digit($includePenalty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includePenalty, true), gettype($includePenalty)), __LINE__);
        }
        $this->IncludePenalty = $includePenalty;
        return $this;
    }
    /**
     * Get IncludeSSR value
     * @return int|null
     */
    public function getIncludeSSR()
    {
        return $this->IncludeSSR;
    }
    /**
     * Set IncludeSSR value
     * @param int $includeSSR
     * @return \StructType\Voucher
     */
    public function setIncludeSSR($includeSSR = null)
    {
        // validation for constraint: int
        if (!is_null($includeSSR) && !(is_int($includeSSR) || ctype_digit($includeSSR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includeSSR, true), gettype($includeSSR)), __LINE__);
        }
        $this->IncludeSSR = $includeSSR;
        return $this;
    }
    /**
     * Get IncludeAuto value
     * @return int|null
     */
    public function getIncludeAuto()
    {
        return $this->IncludeAuto;
    }
    /**
     * Set IncludeAuto value
     * @param int $includeAuto
     * @return \StructType\Voucher
     */
    public function setIncludeAuto($includeAuto = null)
    {
        // validation for constraint: int
        if (!is_null($includeAuto) && !(is_int($includeAuto) || ctype_digit($includeAuto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includeAuto, true), gettype($includeAuto)), __LINE__);
        }
        $this->IncludeAuto = $includeAuto;
        return $this;
    }
    /**
     * Get IncludeHotel value
     * @return int|null
     */
    public function getIncludeHotel()
    {
        return $this->IncludeHotel;
    }
    /**
     * Set IncludeHotel value
     * @param int $includeHotel
     * @return \StructType\Voucher
     */
    public function setIncludeHotel($includeHotel = null)
    {
        // validation for constraint: int
        if (!is_null($includeHotel) && !(is_int($includeHotel) || ctype_digit($includeHotel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includeHotel, true), gettype($includeHotel)), __LINE__);
        }
        $this->IncludeHotel = $includeHotel;
        return $this;
    }
    /**
     * Get STimeRestrict value
     * @return string|null
     */
    public function getSTimeRestrict()
    {
        return $this->STimeRestrict;
    }
    /**
     * Set STimeRestrict value
     * @param string $sTimeRestrict
     * @return \StructType\Voucher
     */
    public function setSTimeRestrict($sTimeRestrict = null)
    {
        // validation for constraint: string
        if (!is_null($sTimeRestrict) && !is_string($sTimeRestrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTimeRestrict, true), gettype($sTimeRestrict)), __LINE__);
        }
        $this->STimeRestrict = $sTimeRestrict;
        return $this;
    }
    /**
     * Get ETimeRestrict value
     * @return string|null
     */
    public function getETimeRestrict()
    {
        return $this->ETimeRestrict;
    }
    /**
     * Set ETimeRestrict value
     * @param string $eTimeRestrict
     * @return \StructType\Voucher
     */
    public function setETimeRestrict($eTimeRestrict = null)
    {
        // validation for constraint: string
        if (!is_null($eTimeRestrict) && !is_string($eTimeRestrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eTimeRestrict, true), gettype($eTimeRestrict)), __LINE__);
        }
        $this->ETimeRestrict = $eTimeRestrict;
        return $this;
    }
    /**
     * Get SundayRestrict value
     * @return int|null
     */
    public function getSundayRestrict()
    {
        return $this->SundayRestrict;
    }
    /**
     * Set SundayRestrict value
     * @param int $sundayRestrict
     * @return \StructType\Voucher
     */
    public function setSundayRestrict($sundayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($sundayRestrict) && !(is_int($sundayRestrict) || ctype_digit($sundayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sundayRestrict, true), gettype($sundayRestrict)), __LINE__);
        }
        $this->SundayRestrict = $sundayRestrict;
        return $this;
    }
    /**
     * Get MondayRestrict value
     * @return int|null
     */
    public function getMondayRestrict()
    {
        return $this->MondayRestrict;
    }
    /**
     * Set MondayRestrict value
     * @param int $mondayRestrict
     * @return \StructType\Voucher
     */
    public function setMondayRestrict($mondayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($mondayRestrict) && !(is_int($mondayRestrict) || ctype_digit($mondayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mondayRestrict, true), gettype($mondayRestrict)), __LINE__);
        }
        $this->MondayRestrict = $mondayRestrict;
        return $this;
    }
    /**
     * Get TuesdayRestrict value
     * @return int|null
     */
    public function getTuesdayRestrict()
    {
        return $this->TuesdayRestrict;
    }
    /**
     * Set TuesdayRestrict value
     * @param int $tuesdayRestrict
     * @return \StructType\Voucher
     */
    public function setTuesdayRestrict($tuesdayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($tuesdayRestrict) && !(is_int($tuesdayRestrict) || ctype_digit($tuesdayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tuesdayRestrict, true), gettype($tuesdayRestrict)), __LINE__);
        }
        $this->TuesdayRestrict = $tuesdayRestrict;
        return $this;
    }
    /**
     * Get WednesdayRestrict value
     * @return int|null
     */
    public function getWednesdayRestrict()
    {
        return $this->WednesdayRestrict;
    }
    /**
     * Set WednesdayRestrict value
     * @param int $wednesdayRestrict
     * @return \StructType\Voucher
     */
    public function setWednesdayRestrict($wednesdayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($wednesdayRestrict) && !(is_int($wednesdayRestrict) || ctype_digit($wednesdayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wednesdayRestrict, true), gettype($wednesdayRestrict)), __LINE__);
        }
        $this->WednesdayRestrict = $wednesdayRestrict;
        return $this;
    }
    /**
     * Get ThursdayRestrict value
     * @return int|null
     */
    public function getThursdayRestrict()
    {
        return $this->ThursdayRestrict;
    }
    /**
     * Set ThursdayRestrict value
     * @param int $thursdayRestrict
     * @return \StructType\Voucher
     */
    public function setThursdayRestrict($thursdayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($thursdayRestrict) && !(is_int($thursdayRestrict) || ctype_digit($thursdayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thursdayRestrict, true), gettype($thursdayRestrict)), __LINE__);
        }
        $this->ThursdayRestrict = $thursdayRestrict;
        return $this;
    }
    /**
     * Get FridayRestrict value
     * @return int|null
     */
    public function getFridayRestrict()
    {
        return $this->FridayRestrict;
    }
    /**
     * Set FridayRestrict value
     * @param int $fridayRestrict
     * @return \StructType\Voucher
     */
    public function setFridayRestrict($fridayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($fridayRestrict) && !(is_int($fridayRestrict) || ctype_digit($fridayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fridayRestrict, true), gettype($fridayRestrict)), __LINE__);
        }
        $this->FridayRestrict = $fridayRestrict;
        return $this;
    }
    /**
     * Get SaturdayRestrict value
     * @return int|null
     */
    public function getSaturdayRestrict()
    {
        return $this->SaturdayRestrict;
    }
    /**
     * Set SaturdayRestrict value
     * @param int $saturdayRestrict
     * @return \StructType\Voucher
     */
    public function setSaturdayRestrict($saturdayRestrict = null)
    {
        // validation for constraint: int
        if (!is_null($saturdayRestrict) && !(is_int($saturdayRestrict) || ctype_digit($saturdayRestrict))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saturdayRestrict, true), gettype($saturdayRestrict)), __LINE__);
        }
        $this->SaturdayRestrict = $saturdayRestrict;
        return $this;
    }
    /**
     * Get VoucherNumFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherNumFull()
    {
        return isset($this->VoucherNumFull) ? $this->VoucherNumFull : null;
    }
    /**
     * Set VoucherNumFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherNumFull
     * @return \StructType\Voucher
     */
    public function setVoucherNumFull($voucherNumFull = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumFull) && !is_string($voucherNumFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumFull, true), gettype($voucherNumFull)), __LINE__);
        }
        if (is_null($voucherNumFull) || (is_array($voucherNumFull) && empty($voucherNumFull))) {
            unset($this->VoucherNumFull);
        } else {
            $this->VoucherNumFull = $voucherNumFull;
        }
        return $this;
    }
    /**
     * Get VoucherPW value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherPW()
    {
        return isset($this->VoucherPW) ? $this->VoucherPW : null;
    }
    /**
     * Set VoucherPW value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherPW
     * @return \StructType\Voucher
     */
    public function setVoucherPW($voucherPW = null)
    {
        // validation for constraint: string
        if (!is_null($voucherPW) && !is_string($voucherPW)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherPW, true), gettype($voucherPW)), __LINE__);
        }
        if (is_null($voucherPW) || (is_array($voucherPW) && empty($voucherPW))) {
            unset($this->VoucherPW);
        } else {
            $this->VoucherPW = $voucherPW;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Voucher
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Voucher
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get TravelEffectiveDate value
     * @return string|null
     */
    public function getTravelEffectiveDate()
    {
        return $this->TravelEffectiveDate;
    }
    /**
     * Set TravelEffectiveDate value
     * @param string $travelEffectiveDate
     * @return \StructType\Voucher
     */
    public function setTravelEffectiveDate($travelEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelEffectiveDate) && !is_string($travelEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelEffectiveDate, true), gettype($travelEffectiveDate)), __LINE__);
        }
        $this->TravelEffectiveDate = $travelEffectiveDate;
        return $this;
    }
    /**
     * Get TravelExpirationDate value
     * @return string|null
     */
    public function getTravelExpirationDate()
    {
        return $this->TravelExpirationDate;
    }
    /**
     * Set TravelExpirationDate value
     * @param string $travelExpirationDate
     * @return \StructType\Voucher
     */
    public function setTravelExpirationDate($travelExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($travelExpirationDate) && !is_string($travelExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelExpirationDate, true), gettype($travelExpirationDate)), __LINE__);
        }
        $this->TravelExpirationDate = $travelExpirationDate;
        return $this;
    }
    /**
     * Get LogicalFlightsKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogicalFlightsKey()
    {
        return isset($this->LogicalFlightsKey) ? $this->LogicalFlightsKey : null;
    }
    /**
     * Set LogicalFlightsKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logicalFlightsKey
     * @return \StructType\Voucher
     */
    public function setLogicalFlightsKey($logicalFlightsKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightsKey) && !is_string($logicalFlightsKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightsKey, true), gettype($logicalFlightsKey)), __LINE__);
        }
        if (is_null($logicalFlightsKey) || (is_array($logicalFlightsKey) && empty($logicalFlightsKey))) {
            unset($this->LogicalFlightsKey);
        } else {
            $this->LogicalFlightsKey = $logicalFlightsKey;
        }
        return $this;
    }
}
