<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OAFlight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OAFlight
 * @subpackage Structs
 */
class OAFlight extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The OALogicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OALogicalFlightID;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The OperatingCarrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrier;
    /**
     * The OperatingFlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureTime;
    /**
     * The Arrivaltime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Arrivaltime;
    /**
     * The OAFlightPersons
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOAFlightPerson
     */
    public $OAFlightPersons;
    /**
     * Constructor method for OAFlight
     * @uses OAFlight::setKey()
     * @uses OAFlight::setOALogicalFlightID()
     * @uses OAFlight::setDepartureDate()
     * @uses OAFlight::setOrigin()
     * @uses OAFlight::setDestination()
     * @uses OAFlight::setOperatingCarrier()
     * @uses OAFlight::setOperatingFlightNumber()
     * @uses OAFlight::setDepartureTime()
     * @uses OAFlight::setArrivaltime()
     * @uses OAFlight::setOAFlightPersons()
     * @param string $key
     * @param int $oALogicalFlightID
     * @param string $departureDate
     * @param string $origin
     * @param string $destination
     * @param string $operatingCarrier
     * @param string $operatingFlightNumber
     * @param string $departureTime
     * @param string $arrivaltime
     * @param \ArrayType\ArrayOfOAFlightPerson $oAFlightPersons
     */
    public function __construct($key = null, $oALogicalFlightID = null, $departureDate = null, $origin = null, $destination = null, $operatingCarrier = null, $operatingFlightNumber = null, $departureTime = null, $arrivaltime = null, \ArrayType\ArrayOfOAFlightPerson $oAFlightPersons = null)
    {
        $this
            ->setKey($key)
            ->setOALogicalFlightID($oALogicalFlightID)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setOperatingCarrier($operatingCarrier)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setDepartureTime($departureTime)
            ->setArrivaltime($arrivaltime)
            ->setOAFlightPersons($oAFlightPersons);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\OAFlight
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get OALogicalFlightID value
     * @return int|null
     */
    public function getOALogicalFlightID()
    {
        return $this->OALogicalFlightID;
    }
    /**
     * Set OALogicalFlightID value
     * @param int $oALogicalFlightID
     * @return \StructType\OAFlight
     */
    public function setOALogicalFlightID($oALogicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($oALogicalFlightID) && !(is_int($oALogicalFlightID) || ctype_digit($oALogicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oALogicalFlightID, true), gettype($oALogicalFlightID)), __LINE__);
        }
        $this->OALogicalFlightID = $oALogicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\OAFlight
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\OAFlight
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\OAFlight
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrier()
    {
        return isset($this->OperatingCarrier) ? $this->OperatingCarrier : null;
    }
    /**
     * Set OperatingCarrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrier
     * @return \StructType\OAFlight
     */
    public function setOperatingCarrier($operatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrier) && !is_string($operatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrier, true), gettype($operatingCarrier)), __LINE__);
        }
        if (is_null($operatingCarrier) || (is_array($operatingCarrier) && empty($operatingCarrier))) {
            unset($this->OperatingCarrier);
        } else {
            $this->OperatingCarrier = $operatingCarrier;
        }
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return isset($this->OperatingFlightNumber) ? $this->OperatingFlightNumber : null;
    }
    /**
     * Set OperatingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingFlightNumber
     * @return \StructType\OAFlight
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNumber, true), gettype($operatingFlightNumber)), __LINE__);
        }
        if (is_null($operatingFlightNumber) || (is_array($operatingFlightNumber) && empty($operatingFlightNumber))) {
            unset($this->OperatingFlightNumber);
        } else {
            $this->OperatingFlightNumber = $operatingFlightNumber;
        }
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\OAFlight
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Arrivaltime value
     * @return string|null
     */
    public function getArrivaltime()
    {
        return $this->Arrivaltime;
    }
    /**
     * Set Arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\OAFlight
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        $this->Arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get OAFlightPersons value
     * @return \ArrayType\ArrayOfOAFlightPerson|null
     */
    public function getOAFlightPersons()
    {
        return $this->OAFlightPersons;
    }
    /**
     * Set OAFlightPersons value
     * @param \ArrayType\ArrayOfOAFlightPerson $oAFlightPersons
     * @return \StructType\OAFlight
     */
    public function setOAFlightPersons(\ArrayType\ArrayOfOAFlightPerson $oAFlightPersons = null)
    {
        $this->OAFlightPersons = $oAFlightPersons;
        return $this;
    }
}
