<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Format3DSecureInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Format3DSecureInformation
 * @subpackage Structs
 */
class Format3DSecureInformation extends TransactionInfo
{
    /**
     * The Format3DSecureInformationRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Format3DSecureInformation
     */
    public $Format3DSecureInformationRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The ReservationPaymentId
     * @var int
     */
    public $ReservationPaymentId;
    /**
     * The ReturnURL
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReturnURL;
    /**
     * Constructor method for Format3DSecureInformation
     * @uses Format3DSecureInformation::setFormat3DSecureInformationRequest()
     * @uses Format3DSecureInformation::setActionType()
     * @uses Format3DSecureInformation::setReservationInfo()
     * @uses Format3DSecureInformation::setReservationPaymentId()
     * @uses Format3DSecureInformation::setReturnURL()
     * @param \StructType\Format3DSecureInformation $format3DSecureInformationRequest
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param int $reservationPaymentId
     * @param string $returnURL
     */
    public function __construct(\StructType\Format3DSecureInformation $format3DSecureInformationRequest = null, $actionType = null, \StructType\ReservationInfo $reservationInfo = null, $reservationPaymentId = null, $returnURL = null)
    {
        $this
            ->setFormat3DSecureInformationRequest($format3DSecureInformationRequest)
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setReservationPaymentId($reservationPaymentId)
            ->setReturnURL($returnURL);
    }
    /**
     * Get Format3DSecureInformationRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Format3DSecureInformation|null
     */
    public function getFormat3DSecureInformationRequest()
    {
        return isset($this->Format3DSecureInformationRequest) ? $this->Format3DSecureInformationRequest : null;
    }
    /**
     * Set Format3DSecureInformationRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Format3DSecureInformation $format3DSecureInformationRequest
     * @return \StructType\Format3DSecureInformation
     */
    public function setFormat3DSecureInformationRequest(\StructType\Format3DSecureInformation $format3DSecureInformationRequest = null)
    {
        if (is_null($format3DSecureInformationRequest) || (is_array($format3DSecureInformationRequest) && empty($format3DSecureInformationRequest))) {
            unset($this->Format3DSecureInformationRequest);
        } else {
            $this->Format3DSecureInformationRequest = $format3DSecureInformationRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\Format3DSecureInformation_ActionTypes::valueIsValid()
     * @uses \EnumType\Format3DSecureInformation_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\Format3DSecureInformation
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Format3DSecureInformation_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Format3DSecureInformation_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\Format3DSecureInformation_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\Format3DSecureInformation
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get ReservationPaymentId value
     * @return int|null
     */
    public function getReservationPaymentId()
    {
        return $this->ReservationPaymentId;
    }
    /**
     * Set ReservationPaymentId value
     * @param int $reservationPaymentId
     * @return \StructType\Format3DSecureInformation
     */
    public function setReservationPaymentId($reservationPaymentId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationPaymentId) && !(is_int($reservationPaymentId) || ctype_digit($reservationPaymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationPaymentId, true), gettype($reservationPaymentId)), __LINE__);
        }
        $this->ReservationPaymentId = $reservationPaymentId;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \StructType\Format3DSecureInformation
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURL, true), gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
}
