<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTicketingTimeLimit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateTicketingTimeLimit
 * @subpackage Structs
 */
class UpdateTicketingTimeLimit extends TransactionInfo
{
    /**
     * The UpdateTicketingTimeLimitRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UpdateTicketingTimeLimit
     */
    public $UpdateTicketingTimeLimitRequest;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The TicketingTimeLimit
     * @var string
     */
    public $TicketingTimeLimit;
    /**
     * The PayLaterOptionSelected
     * @var bool
     */
    public $PayLaterOptionSelected;
    /**
     * Constructor method for UpdateTicketingTimeLimit
     * @uses UpdateTicketingTimeLimit::setUpdateTicketingTimeLimitRequest()
     * @uses UpdateTicketingTimeLimit::setReservationInfo()
     * @uses UpdateTicketingTimeLimit::setTicketingTimeLimit()
     * @uses UpdateTicketingTimeLimit::setPayLaterOptionSelected()
     * @param \StructType\UpdateTicketingTimeLimit $updateTicketingTimeLimitRequest
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $ticketingTimeLimit
     * @param bool $payLaterOptionSelected
     */
    public function __construct(\StructType\UpdateTicketingTimeLimit $updateTicketingTimeLimitRequest = null, \StructType\ReservationInfo $reservationInfo = null, $ticketingTimeLimit = null, $payLaterOptionSelected = null)
    {
        $this
            ->setUpdateTicketingTimeLimitRequest($updateTicketingTimeLimitRequest)
            ->setReservationInfo($reservationInfo)
            ->setTicketingTimeLimit($ticketingTimeLimit)
            ->setPayLaterOptionSelected($payLaterOptionSelected);
    }
    /**
     * Get UpdateTicketingTimeLimitRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UpdateTicketingTimeLimit|null
     */
    public function getUpdateTicketingTimeLimitRequest()
    {
        return isset($this->UpdateTicketingTimeLimitRequest) ? $this->UpdateTicketingTimeLimitRequest : null;
    }
    /**
     * Set UpdateTicketingTimeLimitRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UpdateTicketingTimeLimit $updateTicketingTimeLimitRequest
     * @return \StructType\UpdateTicketingTimeLimit
     */
    public function setUpdateTicketingTimeLimitRequest(\StructType\UpdateTicketingTimeLimit $updateTicketingTimeLimitRequest = null)
    {
        if (is_null($updateTicketingTimeLimitRequest) || (is_array($updateTicketingTimeLimitRequest) && empty($updateTicketingTimeLimitRequest))) {
            unset($this->UpdateTicketingTimeLimitRequest);
        } else {
            $this->UpdateTicketingTimeLimitRequest = $updateTicketingTimeLimitRequest;
        }
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\UpdateTicketingTimeLimit
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get TicketingTimeLimit value
     * @return string|null
     */
    public function getTicketingTimeLimit()
    {
        return $this->TicketingTimeLimit;
    }
    /**
     * Set TicketingTimeLimit value
     * @param string $ticketingTimeLimit
     * @return \StructType\UpdateTicketingTimeLimit
     */
    public function setTicketingTimeLimit($ticketingTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingTimeLimit) && !is_string($ticketingTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingTimeLimit, true), gettype($ticketingTimeLimit)), __LINE__);
        }
        $this->TicketingTimeLimit = $ticketingTimeLimit;
        return $this;
    }
    /**
     * Get PayLaterOptionSelected value
     * @return bool|null
     */
    public function getPayLaterOptionSelected()
    {
        return $this->PayLaterOptionSelected;
    }
    /**
     * Set PayLaterOptionSelected value
     * @param bool $payLaterOptionSelected
     * @return \StructType\UpdateTicketingTimeLimit
     */
    public function setPayLaterOptionSelected($payLaterOptionSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($payLaterOptionSelected) && !is_bool($payLaterOptionSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payLaterOptionSelected, true), gettype($payLaterOptionSelected)), __LINE__);
        }
        $this->PayLaterOptionSelected = $payLaterOptionSelected;
        return $this;
    }
}
