<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConvertedReservationBalanceResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetConvertedReservationBalanceResponse
 * @subpackage Structs
 */
class GetConvertedReservationBalanceResponse extends TransactionInfo
{
    /**
     * The GetConvertedReservationBalanceResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetConvertedReservationBalanceResponse
     */
    public $GetConvertedReservationBalanceResult;
    /**
     * The ConvertedAmount
     * @var float
     */
    public $ConvertedAmount;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for GetConvertedReservationBalanceResponse
     * @uses GetConvertedReservationBalanceResponse::setGetConvertedReservationBalanceResult()
     * @uses GetConvertedReservationBalanceResponse::setConvertedAmount()
     * @uses GetConvertedReservationBalanceResponse::setExceptions()
     * @param \StructType\GetConvertedReservationBalanceResponse $getConvertedReservationBalanceResult
     * @param float $convertedAmount
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\GetConvertedReservationBalanceResponse $getConvertedReservationBalanceResult = null, $convertedAmount = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setGetConvertedReservationBalanceResult($getConvertedReservationBalanceResult)
            ->setConvertedAmount($convertedAmount)
            ->setExceptions($exceptions);
    }
    /**
     * Get GetConvertedReservationBalanceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetConvertedReservationBalanceResponse|null
     */
    public function getGetConvertedReservationBalanceResult()
    {
        return isset($this->GetConvertedReservationBalanceResult) ? $this->GetConvertedReservationBalanceResult : null;
    }
    /**
     * Set GetConvertedReservationBalanceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetConvertedReservationBalanceResponse $getConvertedReservationBalanceResult
     * @return \StructType\GetConvertedReservationBalanceResponse
     */
    public function setGetConvertedReservationBalanceResult(\StructType\GetConvertedReservationBalanceResponse $getConvertedReservationBalanceResult = null)
    {
        if (is_null($getConvertedReservationBalanceResult) || (is_array($getConvertedReservationBalanceResult) && empty($getConvertedReservationBalanceResult))) {
            unset($this->GetConvertedReservationBalanceResult);
        } else {
            $this->GetConvertedReservationBalanceResult = $getConvertedReservationBalanceResult;
        }
        return $this;
    }
    /**
     * Get ConvertedAmount value
     * @return float|null
     */
    public function getConvertedAmount()
    {
        return $this->ConvertedAmount;
    }
    /**
     * Set ConvertedAmount value
     * @param float $convertedAmount
     * @return \StructType\GetConvertedReservationBalanceResponse
     */
    public function setConvertedAmount($convertedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($convertedAmount) && !(is_float($convertedAmount) || is_numeric($convertedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($convertedAmount, true), gettype($convertedAmount)), __LINE__);
        }
        $this->ConvertedAmount = $convertedAmount;
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\GetConvertedReservationBalanceResponse
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
