<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateExternalProcessedPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateExternalProcessedPayment $parameters
     * @return \StructType\UpdateExternalProcessedPaymentResponse|bool
     */
    public function UpdateExternalProcessedPayment(\StructType\UpdateExternalProcessedPayment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExternalProcessedPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketingTimeLimit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTicketingTimeLimit $parameters
     * @return \StructType\UpdateTicketingTimeLimitResponse|bool
     */
    public function UpdateTicketingTimeLimit(\StructType\UpdateTicketingTimeLimit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketingTimeLimit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateExternalProcessedPaymentDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateExternalProcessedPaymentDetails $parameters
     * @return \StructType\UpdateExternalProcessedPaymentDetailsResponse|bool
     */
    public function UpdateExternalProcessedPaymentDetails(\StructType\UpdateExternalProcessedPaymentDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExternalProcessedPaymentDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateExternalProcessedPaymentDetailsResponse|\StructType\UpdateExternalProcessedPaymentResponse|\StructType\UpdateTicketingTimeLimitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
