<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Segments StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Segments
 * @subpackage Structs
 */
class Segments extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Legs
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLegdetails
     */
    public $Legs;
    /**
     * Constructor method for Segments
     * @uses Segments::setOrigin()
     * @uses Segments::setDestination()
     * @uses Segments::setDepartureDate()
     * @uses Segments::setArrivalDate()
     * @uses Segments::setLegs()
     * @param string $origin
     * @param string $destination
     * @param string $departureDate
     * @param string $arrivalDate
     * @param \ArrayType\ArrayOfLegdetails $legs
     */
    public function __construct($origin = null, $destination = null, $departureDate = null, $arrivalDate = null, \ArrayType\ArrayOfLegdetails $legs = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setLegs($legs);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\Segments
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\Segments
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\Segments
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\Segments
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Legs value
     * @return \ArrayType\ArrayOfLegdetails|null
     */
    public function getLegs()
    {
        return $this->Legs;
    }
    /**
     * Set Legs value
     * @param \ArrayType\ArrayOfLegdetails $legs
     * @return \StructType\Segments
     */
    public function setLegs(\ArrayType\ArrayOfLegdetails $legs = null)
    {
        $this->Legs = $legs;
        return $this;
    }
}
