<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatWBZoneDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatWBZoneDisplay
 * @subpackage Structs
 */
class SeatWBZoneDisplay extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AutoSeatPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AutoSeatPriority;
    /**
     * The SeatConfigId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatConfigId;
    /**
     * The SeatWBZoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatWBZoneId;
    /**
     * The WBZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBZone;
    /**
     * The ZoneReferenced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ZoneReferenced;
    /**
     * Constructor method for SeatWBZoneDisplay
     * @uses SeatWBZoneDisplay::setActive()
     * @uses SeatWBZoneDisplay::setAutoSeatPriority()
     * @uses SeatWBZoneDisplay::setSeatConfigId()
     * @uses SeatWBZoneDisplay::setSeatWBZoneId()
     * @uses SeatWBZoneDisplay::setWBZone()
     * @uses SeatWBZoneDisplay::setZoneReferenced()
     * @param bool $active
     * @param int $autoSeatPriority
     * @param int $seatConfigId
     * @param int $seatWBZoneId
     * @param string $wBZone
     * @param bool $zoneReferenced
     */
    public function __construct($active = null, $autoSeatPriority = null, $seatConfigId = null, $seatWBZoneId = null, $wBZone = null, $zoneReferenced = null)
    {
        $this
            ->setActive($active)
            ->setAutoSeatPriority($autoSeatPriority)
            ->setSeatConfigId($seatConfigId)
            ->setSeatWBZoneId($seatWBZoneId)
            ->setWBZone($wBZone)
            ->setZoneReferenced($zoneReferenced);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AutoSeatPriority value
     * @return int|null
     */
    public function getAutoSeatPriority()
    {
        return $this->AutoSeatPriority;
    }
    /**
     * Set AutoSeatPriority value
     * @param int $autoSeatPriority
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setAutoSeatPriority($autoSeatPriority = null)
    {
        // validation for constraint: int
        if (!is_null($autoSeatPriority) && !(is_int($autoSeatPriority) || ctype_digit($autoSeatPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($autoSeatPriority, true), gettype($autoSeatPriority)), __LINE__);
        }
        $this->AutoSeatPriority = $autoSeatPriority;
        return $this;
    }
    /**
     * Get SeatConfigId value
     * @return int|null
     */
    public function getSeatConfigId()
    {
        return $this->SeatConfigId;
    }
    /**
     * Set SeatConfigId value
     * @param int $seatConfigId
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setSeatConfigId($seatConfigId = null)
    {
        // validation for constraint: int
        if (!is_null($seatConfigId) && !(is_int($seatConfigId) || ctype_digit($seatConfigId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatConfigId, true), gettype($seatConfigId)), __LINE__);
        }
        $this->SeatConfigId = $seatConfigId;
        return $this;
    }
    /**
     * Get SeatWBZoneId value
     * @return int|null
     */
    public function getSeatWBZoneId()
    {
        return $this->SeatWBZoneId;
    }
    /**
     * Set SeatWBZoneId value
     * @param int $seatWBZoneId
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setSeatWBZoneId($seatWBZoneId = null)
    {
        // validation for constraint: int
        if (!is_null($seatWBZoneId) && !(is_int($seatWBZoneId) || ctype_digit($seatWBZoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatWBZoneId, true), gettype($seatWBZoneId)), __LINE__);
        }
        $this->SeatWBZoneId = $seatWBZoneId;
        return $this;
    }
    /**
     * Get WBZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBZone()
    {
        return isset($this->WBZone) ? $this->WBZone : null;
    }
    /**
     * Set WBZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBZone
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setWBZone($wBZone = null)
    {
        // validation for constraint: string
        if (!is_null($wBZone) && !is_string($wBZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wBZone, true), gettype($wBZone)), __LINE__);
        }
        if (is_null($wBZone) || (is_array($wBZone) && empty($wBZone))) {
            unset($this->WBZone);
        } else {
            $this->WBZone = $wBZone;
        }
        return $this;
    }
    /**
     * Get ZoneReferenced value
     * @return bool|null
     */
    public function getZoneReferenced()
    {
        return $this->ZoneReferenced;
    }
    /**
     * Set ZoneReferenced value
     * @param bool $zoneReferenced
     * @return \StructType\SeatWBZoneDisplay
     */
    public function setZoneReferenced($zoneReferenced = null)
    {
        // validation for constraint: boolean
        if (!is_null($zoneReferenced) && !is_bool($zoneReferenced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zoneReferenced, true), gettype($zoneReferenced)), __LINE__);
        }
        $this->ZoneReferenced = $zoneReferenced;
        return $this;
    }
}
