<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatPriceOffer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatPriceOffer
 * @subpackage Structs
 */
class SeatPriceOffer extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ApplicablePersonOrgIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ApplicablePersonOrgIds;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The IsBundleOffer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsBundleOffer;
    /**
     * Constructor method for SeatPriceOffer
     * @uses SeatPriceOffer::setAmount()
     * @uses SeatPriceOffer::setApplicablePersonOrgIds()
     * @uses SeatPriceOffer::setCurrency()
     * @uses SeatPriceOffer::setIsBundleOffer()
     * @param float $amount
     * @param \ArrayType\ArrayOflong $applicablePersonOrgIds
     * @param string $currency
     * @param bool $isBundleOffer
     */
    public function __construct($amount = null, \ArrayType\ArrayOflong $applicablePersonOrgIds = null, $currency = null, $isBundleOffer = null)
    {
        $this
            ->setAmount($amount)
            ->setApplicablePersonOrgIds($applicablePersonOrgIds)
            ->setCurrency($currency)
            ->setIsBundleOffer($isBundleOffer);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SeatPriceOffer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApplicablePersonOrgIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getApplicablePersonOrgIds()
    {
        return isset($this->ApplicablePersonOrgIds) ? $this->ApplicablePersonOrgIds : null;
    }
    /**
     * Set ApplicablePersonOrgIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $applicablePersonOrgIds
     * @return \StructType\SeatPriceOffer
     */
    public function setApplicablePersonOrgIds(\ArrayType\ArrayOflong $applicablePersonOrgIds = null)
    {
        if (is_null($applicablePersonOrgIds) || (is_array($applicablePersonOrgIds) && empty($applicablePersonOrgIds))) {
            unset($this->ApplicablePersonOrgIds);
        } else {
            $this->ApplicablePersonOrgIds = $applicablePersonOrgIds;
        }
        return $this;
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\SeatPriceOffer
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get IsBundleOffer value
     * @return bool|null
     */
    public function getIsBundleOffer()
    {
        return $this->IsBundleOffer;
    }
    /**
     * Set IsBundleOffer value
     * @param bool $isBundleOffer
     * @return \StructType\SeatPriceOffer
     */
    public function setIsBundleOffer($isBundleOffer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBundleOffer) && !is_bool($isBundleOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBundleOffer, true), gettype($isBundleOffer)), __LINE__);
        }
        $this->IsBundleOffer = $isBundleOffer;
        return $this;
    }
}
