<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatDisplay
 * @subpackage Structs
 */
class SeatDisplay extends AbstractStructBase
{
    /**
     * The CabinClassId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CabinClassId;
    /**
     * The IsSeatAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSeatAvailable;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRestrictionDisplay
     */
    public $Restrictions;
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowId;
    /**
     * The SeatAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SeatAssignDisplay
     */
    public $SeatAssignment;
    /**
     * The SeatAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatAttributeDisplay
     */
    public $SeatAttributes;
    /**
     * The SeatCabinId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatCabinId;
    /**
     * The SeatColumn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatColumn;
    /**
     * The SeatHeld
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\HeldSeatDisplay
     */
    public $SeatHeld;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatId;
    /**
     * The SeatOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatOrder;
    /**
     * The SeatPriceOffers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatPriceOffer
     */
    public $SeatPriceOffers;
    /**
     * The SeatWBZoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatWBZoneId;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * The ServiceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceDescription;
    /**
     * The ServiceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ServiceId;
    /**
     * The WeightIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WeightIndex;
    /**
     * Constructor method for SeatDisplay
     * @uses SeatDisplay::setCabinClassId()
     * @uses SeatDisplay::setIsSeatAvailable()
     * @uses SeatDisplay::setRestrictions()
     * @uses SeatDisplay::setRowId()
     * @uses SeatDisplay::setSeatAssignment()
     * @uses SeatDisplay::setSeatAttributes()
     * @uses SeatDisplay::setSeatCabinId()
     * @uses SeatDisplay::setSeatColumn()
     * @uses SeatDisplay::setSeatHeld()
     * @uses SeatDisplay::setSeatId()
     * @uses SeatDisplay::setSeatOrder()
     * @uses SeatDisplay::setSeatPriceOffers()
     * @uses SeatDisplay::setSeatWBZoneId()
     * @uses SeatDisplay::setServiceCode()
     * @uses SeatDisplay::setServiceDescription()
     * @uses SeatDisplay::setServiceId()
     * @uses SeatDisplay::setWeightIndex()
     * @param int $cabinClassId
     * @param bool $isSeatAvailable
     * @param \ArrayType\ArrayOfRestrictionDisplay $restrictions
     * @param int $rowId
     * @param \StructType\SeatAssignDisplay $seatAssignment
     * @param \ArrayType\ArrayOfSeatAttributeDisplay $seatAttributes
     * @param int $seatCabinId
     * @param string $seatColumn
     * @param \StructType\HeldSeatDisplay $seatHeld
     * @param int $seatId
     * @param int $seatOrder
     * @param \ArrayType\ArrayOfSeatPriceOffer $seatPriceOffers
     * @param int $seatWBZoneId
     * @param string $serviceCode
     * @param string $serviceDescription
     * @param int $serviceId
     * @param int $weightIndex
     */
    public function __construct($cabinClassId = null, $isSeatAvailable = null, \ArrayType\ArrayOfRestrictionDisplay $restrictions = null, $rowId = null, \StructType\SeatAssignDisplay $seatAssignment = null, \ArrayType\ArrayOfSeatAttributeDisplay $seatAttributes = null, $seatCabinId = null, $seatColumn = null, \StructType\HeldSeatDisplay $seatHeld = null, $seatId = null, $seatOrder = null, \ArrayType\ArrayOfSeatPriceOffer $seatPriceOffers = null, $seatWBZoneId = null, $serviceCode = null, $serviceDescription = null, $serviceId = null, $weightIndex = null)
    {
        $this
            ->setCabinClassId($cabinClassId)
            ->setIsSeatAvailable($isSeatAvailable)
            ->setRestrictions($restrictions)
            ->setRowId($rowId)
            ->setSeatAssignment($seatAssignment)
            ->setSeatAttributes($seatAttributes)
            ->setSeatCabinId($seatCabinId)
            ->setSeatColumn($seatColumn)
            ->setSeatHeld($seatHeld)
            ->setSeatId($seatId)
            ->setSeatOrder($seatOrder)
            ->setSeatPriceOffers($seatPriceOffers)
            ->setSeatWBZoneId($seatWBZoneId)
            ->setServiceCode($serviceCode)
            ->setServiceDescription($serviceDescription)
            ->setServiceId($serviceId)
            ->setWeightIndex($weightIndex);
    }
    /**
     * Get CabinClassId value
     * @return int|null
     */
    public function getCabinClassId()
    {
        return $this->CabinClassId;
    }
    /**
     * Set CabinClassId value
     * @param int $cabinClassId
     * @return \StructType\SeatDisplay
     */
    public function setCabinClassId($cabinClassId = null)
    {
        // validation for constraint: int
        if (!is_null($cabinClassId) && !(is_int($cabinClassId) || ctype_digit($cabinClassId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinClassId, true), gettype($cabinClassId)), __LINE__);
        }
        $this->CabinClassId = $cabinClassId;
        return $this;
    }
    /**
     * Get IsSeatAvailable value
     * @return bool|null
     */
    public function getIsSeatAvailable()
    {
        return $this->IsSeatAvailable;
    }
    /**
     * Set IsSeatAvailable value
     * @param bool $isSeatAvailable
     * @return \StructType\SeatDisplay
     */
    public function setIsSeatAvailable($isSeatAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeatAvailable) && !is_bool($isSeatAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeatAvailable, true), gettype($isSeatAvailable)), __LINE__);
        }
        $this->IsSeatAvailable = $isSeatAvailable;
        return $this;
    }
    /**
     * Get Restrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRestrictionDisplay|null
     */
    public function getRestrictions()
    {
        return isset($this->Restrictions) ? $this->Restrictions : null;
    }
    /**
     * Set Restrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRestrictionDisplay $restrictions
     * @return \StructType\SeatDisplay
     */
    public function setRestrictions(\ArrayType\ArrayOfRestrictionDisplay $restrictions = null)
    {
        if (is_null($restrictions) || (is_array($restrictions) && empty($restrictions))) {
            unset($this->Restrictions);
        } else {
            $this->Restrictions = $restrictions;
        }
        return $this;
    }
    /**
     * Get RowId value
     * @return int|null
     */
    public function getRowId()
    {
        return $this->RowId;
    }
    /**
     * Set RowId value
     * @param int $rowId
     * @return \StructType\SeatDisplay
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        $this->RowId = $rowId;
        return $this;
    }
    /**
     * Get SeatAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SeatAssignDisplay|null
     */
    public function getSeatAssignment()
    {
        return isset($this->SeatAssignment) ? $this->SeatAssignment : null;
    }
    /**
     * Set SeatAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SeatAssignDisplay $seatAssignment
     * @return \StructType\SeatDisplay
     */
    public function setSeatAssignment(\StructType\SeatAssignDisplay $seatAssignment = null)
    {
        if (is_null($seatAssignment) || (is_array($seatAssignment) && empty($seatAssignment))) {
            unset($this->SeatAssignment);
        } else {
            $this->SeatAssignment = $seatAssignment;
        }
        return $this;
    }
    /**
     * Get SeatAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatAttributeDisplay|null
     */
    public function getSeatAttributes()
    {
        return isset($this->SeatAttributes) ? $this->SeatAttributes : null;
    }
    /**
     * Set SeatAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatAttributeDisplay $seatAttributes
     * @return \StructType\SeatDisplay
     */
    public function setSeatAttributes(\ArrayType\ArrayOfSeatAttributeDisplay $seatAttributes = null)
    {
        if (is_null($seatAttributes) || (is_array($seatAttributes) && empty($seatAttributes))) {
            unset($this->SeatAttributes);
        } else {
            $this->SeatAttributes = $seatAttributes;
        }
        return $this;
    }
    /**
     * Get SeatCabinId value
     * @return int|null
     */
    public function getSeatCabinId()
    {
        return $this->SeatCabinId;
    }
    /**
     * Set SeatCabinId value
     * @param int $seatCabinId
     * @return \StructType\SeatDisplay
     */
    public function setSeatCabinId($seatCabinId = null)
    {
        // validation for constraint: int
        if (!is_null($seatCabinId) && !(is_int($seatCabinId) || ctype_digit($seatCabinId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCabinId, true), gettype($seatCabinId)), __LINE__);
        }
        $this->SeatCabinId = $seatCabinId;
        return $this;
    }
    /**
     * Get SeatColumn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatColumn()
    {
        return isset($this->SeatColumn) ? $this->SeatColumn : null;
    }
    /**
     * Set SeatColumn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatColumn
     * @return \StructType\SeatDisplay
     */
    public function setSeatColumn($seatColumn = null)
    {
        // validation for constraint: string
        if (!is_null($seatColumn) && !is_string($seatColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatColumn, true), gettype($seatColumn)), __LINE__);
        }
        if (is_null($seatColumn) || (is_array($seatColumn) && empty($seatColumn))) {
            unset($this->SeatColumn);
        } else {
            $this->SeatColumn = $seatColumn;
        }
        return $this;
    }
    /**
     * Get SeatHeld value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\HeldSeatDisplay|null
     */
    public function getSeatHeld()
    {
        return isset($this->SeatHeld) ? $this->SeatHeld : null;
    }
    /**
     * Set SeatHeld value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\HeldSeatDisplay $seatHeld
     * @return \StructType\SeatDisplay
     */
    public function setSeatHeld(\StructType\HeldSeatDisplay $seatHeld = null)
    {
        if (is_null($seatHeld) || (is_array($seatHeld) && empty($seatHeld))) {
            unset($this->SeatHeld);
        } else {
            $this->SeatHeld = $seatHeld;
        }
        return $this;
    }
    /**
     * Get SeatId value
     * @return int|null
     */
    public function getSeatId()
    {
        return $this->SeatId;
    }
    /**
     * Set SeatId value
     * @param int $seatId
     * @return \StructType\SeatDisplay
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        $this->SeatId = $seatId;
        return $this;
    }
    /**
     * Get SeatOrder value
     * @return int|null
     */
    public function getSeatOrder()
    {
        return $this->SeatOrder;
    }
    /**
     * Set SeatOrder value
     * @param int $seatOrder
     * @return \StructType\SeatDisplay
     */
    public function setSeatOrder($seatOrder = null)
    {
        // validation for constraint: int
        if (!is_null($seatOrder) && !(is_int($seatOrder) || ctype_digit($seatOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatOrder, true), gettype($seatOrder)), __LINE__);
        }
        $this->SeatOrder = $seatOrder;
        return $this;
    }
    /**
     * Get SeatPriceOffers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatPriceOffer|null
     */
    public function getSeatPriceOffers()
    {
        return isset($this->SeatPriceOffers) ? $this->SeatPriceOffers : null;
    }
    /**
     * Set SeatPriceOffers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatPriceOffer $seatPriceOffers
     * @return \StructType\SeatDisplay
     */
    public function setSeatPriceOffers(\ArrayType\ArrayOfSeatPriceOffer $seatPriceOffers = null)
    {
        if (is_null($seatPriceOffers) || (is_array($seatPriceOffers) && empty($seatPriceOffers))) {
            unset($this->SeatPriceOffers);
        } else {
            $this->SeatPriceOffers = $seatPriceOffers;
        }
        return $this;
    }
    /**
     * Get SeatWBZoneId value
     * @return int|null
     */
    public function getSeatWBZoneId()
    {
        return $this->SeatWBZoneId;
    }
    /**
     * Set SeatWBZoneId value
     * @param int $seatWBZoneId
     * @return \StructType\SeatDisplay
     */
    public function setSeatWBZoneId($seatWBZoneId = null)
    {
        // validation for constraint: int
        if (!is_null($seatWBZoneId) && !(is_int($seatWBZoneId) || ctype_digit($seatWBZoneId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatWBZoneId, true), gettype($seatWBZoneId)), __LINE__);
        }
        $this->SeatWBZoneId = $seatWBZoneId;
        return $this;
    }
    /**
     * Get ServiceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceCode()
    {
        return isset($this->ServiceCode) ? $this->ServiceCode : null;
    }
    /**
     * Set ServiceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceCode
     * @return \StructType\SeatDisplay
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        if (is_null($serviceCode) || (is_array($serviceCode) && empty($serviceCode))) {
            unset($this->ServiceCode);
        } else {
            $this->ServiceCode = $serviceCode;
        }
        return $this;
    }
    /**
     * Get ServiceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->ServiceDescription) ? $this->ServiceDescription : null;
    }
    /**
     * Set ServiceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \StructType\SeatDisplay
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDescription, true), gettype($serviceDescription)), __LINE__);
        }
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->ServiceDescription);
        } else {
            $this->ServiceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get ServiceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }
    /**
     * Set ServiceId value
     * @param int $serviceId
     * @return \StructType\SeatDisplay
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !(is_int($serviceId) || ctype_digit($serviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceId, true), gettype($serviceId)), __LINE__);
        }
        $this->ServiceId = $serviceId;
        return $this;
    }
    /**
     * Get WeightIndex value
     * @return int|null
     */
    public function getWeightIndex()
    {
        return $this->WeightIndex;
    }
    /**
     * Set WeightIndex value
     * @param int $weightIndex
     * @return \StructType\SeatDisplay
     */
    public function setWeightIndex($weightIndex = null)
    {
        // validation for constraint: int
        if (!is_null($weightIndex) && !(is_int($weightIndex) || ctype_digit($weightIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weightIndex, true), gettype($weightIndex)), __LINE__);
        }
        $this->WeightIndex = $weightIndex;
        return $this;
    }
}
