<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatConfigurationDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatConfigurationDisplay
 * @subpackage Structs
 */
class SeatConfigurationDisplay extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Carrier;
    /**
     * The ConfigurationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationDescription;
    /**
     * The ConfigurationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationName;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Default;
    /**
     * The IataAcType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IataAcType;
    /**
     * The LayoutName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayoutName;
    /**
     * The Rows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRowDisplay
     */
    public $Rows;
    /**
     * The SeatConfigurationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatConfigurationId;
    /**
     * Constructor method for SeatConfigurationDisplay
     * @uses SeatConfigurationDisplay::setCarrier()
     * @uses SeatConfigurationDisplay::setConfigurationDescription()
     * @uses SeatConfigurationDisplay::setConfigurationName()
     * @uses SeatConfigurationDisplay::setDefault()
     * @uses SeatConfigurationDisplay::setIataAcType()
     * @uses SeatConfigurationDisplay::setLayoutName()
     * @uses SeatConfigurationDisplay::setRows()
     * @uses SeatConfigurationDisplay::setSeatConfigurationId()
     * @param string $carrier
     * @param string $configurationDescription
     * @param string $configurationName
     * @param bool $default
     * @param string $iataAcType
     * @param string $layoutName
     * @param \ArrayType\ArrayOfRowDisplay $rows
     * @param int $seatConfigurationId
     */
    public function __construct($carrier = null, $configurationDescription = null, $configurationName = null, $default = null, $iataAcType = null, $layoutName = null, \ArrayType\ArrayOfRowDisplay $rows = null, $seatConfigurationId = null)
    {
        $this
            ->setCarrier($carrier)
            ->setConfigurationDescription($configurationDescription)
            ->setConfigurationName($configurationName)
            ->setDefault($default)
            ->setIataAcType($iataAcType)
            ->setLayoutName($layoutName)
            ->setRows($rows)
            ->setSeatConfigurationId($seatConfigurationId);
    }
    /**
     * Get Carrier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrier()
    {
        return isset($this->Carrier) ? $this->Carrier : null;
    }
    /**
     * Set Carrier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrier
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        if (is_null($carrier) || (is_array($carrier) && empty($carrier))) {
            unset($this->Carrier);
        } else {
            $this->Carrier = $carrier;
        }
        return $this;
    }
    /**
     * Get ConfigurationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationDescription()
    {
        return isset($this->ConfigurationDescription) ? $this->ConfigurationDescription : null;
    }
    /**
     * Set ConfigurationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configurationDescription
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setConfigurationDescription($configurationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($configurationDescription) && !is_string($configurationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurationDescription, true), gettype($configurationDescription)), __LINE__);
        }
        if (is_null($configurationDescription) || (is_array($configurationDescription) && empty($configurationDescription))) {
            unset($this->ConfigurationDescription);
        } else {
            $this->ConfigurationDescription = $configurationDescription;
        }
        return $this;
    }
    /**
     * Get ConfigurationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationName()
    {
        return isset($this->ConfigurationName) ? $this->ConfigurationName : null;
    }
    /**
     * Set ConfigurationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configurationName
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setConfigurationName($configurationName = null)
    {
        // validation for constraint: string
        if (!is_null($configurationName) && !is_string($configurationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurationName, true), gettype($configurationName)), __LINE__);
        }
        if (is_null($configurationName) || (is_array($configurationName) && empty($configurationName))) {
            unset($this->ConfigurationName);
        } else {
            $this->ConfigurationName = $configurationName;
        }
        return $this;
    }
    /**
     * Get Default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param bool $default
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setDefault($default = null)
    {
        // validation for constraint: boolean
        if (!is_null($default) && !is_bool($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default, true), gettype($default)), __LINE__);
        }
        $this->Default = $default;
        return $this;
    }
    /**
     * Get IataAcType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIataAcType()
    {
        return isset($this->IataAcType) ? $this->IataAcType : null;
    }
    /**
     * Set IataAcType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iataAcType
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setIataAcType($iataAcType = null)
    {
        // validation for constraint: string
        if (!is_null($iataAcType) && !is_string($iataAcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iataAcType, true), gettype($iataAcType)), __LINE__);
        }
        if (is_null($iataAcType) || (is_array($iataAcType) && empty($iataAcType))) {
            unset($this->IataAcType);
        } else {
            $this->IataAcType = $iataAcType;
        }
        return $this;
    }
    /**
     * Get LayoutName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayoutName()
    {
        return isset($this->LayoutName) ? $this->LayoutName : null;
    }
    /**
     * Set LayoutName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layoutName
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setLayoutName($layoutName = null)
    {
        // validation for constraint: string
        if (!is_null($layoutName) && !is_string($layoutName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layoutName, true), gettype($layoutName)), __LINE__);
        }
        if (is_null($layoutName) || (is_array($layoutName) && empty($layoutName))) {
            unset($this->LayoutName);
        } else {
            $this->LayoutName = $layoutName;
        }
        return $this;
    }
    /**
     * Get Rows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRowDisplay|null
     */
    public function getRows()
    {
        return isset($this->Rows) ? $this->Rows : null;
    }
    /**
     * Set Rows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRowDisplay $rows
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setRows(\ArrayType\ArrayOfRowDisplay $rows = null)
    {
        if (is_null($rows) || (is_array($rows) && empty($rows))) {
            unset($this->Rows);
        } else {
            $this->Rows = $rows;
        }
        return $this;
    }
    /**
     * Get SeatConfigurationId value
     * @return int|null
     */
    public function getSeatConfigurationId()
    {
        return $this->SeatConfigurationId;
    }
    /**
     * Set SeatConfigurationId value
     * @param int $seatConfigurationId
     * @return \StructType\SeatConfigurationDisplay
     */
    public function setSeatConfigurationId($seatConfigurationId = null)
    {
        // validation for constraint: int
        if (!is_null($seatConfigurationId) && !(is_int($seatConfigurationId) || ctype_digit($seatConfigurationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatConfigurationId, true), gettype($seatConfigurationId)), __LINE__);
        }
        $this->SeatConfigurationId = $seatConfigurationId;
        return $this;
    }
}
