<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatCode
 * @subpackage Structs
 */
class SeatCode extends AbstractStructBase
{
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The QuantityAvailable
     * @var int
     */
    public $QuantityAvailable;
    /**
     * Constructor method for SeatCode
     * @uses SeatCode::setServiceCode()
     * @uses SeatCode::setDescription()
     * @uses SeatCode::setQuantityAvailable()
     * @param string $serviceCode
     * @param string $description
     * @param int $quantityAvailable
     */
    public function __construct($serviceCode = null, $description = null, $quantityAvailable = null)
    {
        $this
            ->setServiceCode($serviceCode)
            ->setDescription($description)
            ->setQuantityAvailable($quantityAvailable);
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \StructType\SeatCode
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SeatCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get QuantityAvailable value
     * @return int|null
     */
    public function getQuantityAvailable()
    {
        return $this->QuantityAvailable;
    }
    /**
     * Set QuantityAvailable value
     * @param int $quantityAvailable
     * @return \StructType\SeatCode
     */
    public function setQuantityAvailable($quantityAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($quantityAvailable) && !(is_int($quantityAvailable) || ctype_digit($quantityAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityAvailable, true), gettype($quantityAvailable)), __LINE__);
        }
        $this->QuantityAvailable = $quantityAvailable;
        return $this;
    }
}
