<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAttributeDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatAttributeDisplay
 * @subpackage Structs
 */
class SeatAttributeDisplay extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AllowSeating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowSeating;
    /**
     * The AttributeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeCode;
    /**
     * The AttributeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeDescription;
    /**
     * The AttributeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AttributeId;
    /**
     * The AttributeOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AttributeOrder;
    /**
     * The IsCommercial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCommercial;
    /**
     * The IsMarketing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsMarketing;
    /**
     * The IsOperational
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOperational;
    /**
     * The SystemAttribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SystemAttribute;
    /**
     * Constructor method for SeatAttributeDisplay
     * @uses SeatAttributeDisplay::setActive()
     * @uses SeatAttributeDisplay::setAllowSeating()
     * @uses SeatAttributeDisplay::setAttributeCode()
     * @uses SeatAttributeDisplay::setAttributeDescription()
     * @uses SeatAttributeDisplay::setAttributeId()
     * @uses SeatAttributeDisplay::setAttributeOrder()
     * @uses SeatAttributeDisplay::setIsCommercial()
     * @uses SeatAttributeDisplay::setIsMarketing()
     * @uses SeatAttributeDisplay::setIsOperational()
     * @uses SeatAttributeDisplay::setSystemAttribute()
     * @param bool $active
     * @param bool $allowSeating
     * @param string $attributeCode
     * @param string $attributeDescription
     * @param int $attributeId
     * @param int $attributeOrder
     * @param bool $isCommercial
     * @param bool $isMarketing
     * @param bool $isOperational
     * @param bool $systemAttribute
     */
    public function __construct($active = null, $allowSeating = null, $attributeCode = null, $attributeDescription = null, $attributeId = null, $attributeOrder = null, $isCommercial = null, $isMarketing = null, $isOperational = null, $systemAttribute = null)
    {
        $this
            ->setActive($active)
            ->setAllowSeating($allowSeating)
            ->setAttributeCode($attributeCode)
            ->setAttributeDescription($attributeDescription)
            ->setAttributeId($attributeId)
            ->setAttributeOrder($attributeOrder)
            ->setIsCommercial($isCommercial)
            ->setIsMarketing($isMarketing)
            ->setIsOperational($isOperational)
            ->setSystemAttribute($systemAttribute);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\SeatAttributeDisplay
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AllowSeating value
     * @return bool|null
     */
    public function getAllowSeating()
    {
        return $this->AllowSeating;
    }
    /**
     * Set AllowSeating value
     * @param bool $allowSeating
     * @return \StructType\SeatAttributeDisplay
     */
    public function setAllowSeating($allowSeating = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSeating) && !is_bool($allowSeating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSeating, true), gettype($allowSeating)), __LINE__);
        }
        $this->AllowSeating = $allowSeating;
        return $this;
    }
    /**
     * Get AttributeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeCode()
    {
        return isset($this->AttributeCode) ? $this->AttributeCode : null;
    }
    /**
     * Set AttributeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeCode
     * @return \StructType\SeatAttributeDisplay
     */
    public function setAttributeCode($attributeCode = null)
    {
        // validation for constraint: string
        if (!is_null($attributeCode) && !is_string($attributeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeCode, true), gettype($attributeCode)), __LINE__);
        }
        if (is_null($attributeCode) || (is_array($attributeCode) && empty($attributeCode))) {
            unset($this->AttributeCode);
        } else {
            $this->AttributeCode = $attributeCode;
        }
        return $this;
    }
    /**
     * Get AttributeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeDescription()
    {
        return isset($this->AttributeDescription) ? $this->AttributeDescription : null;
    }
    /**
     * Set AttributeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeDescription
     * @return \StructType\SeatAttributeDisplay
     */
    public function setAttributeDescription($attributeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($attributeDescription) && !is_string($attributeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeDescription, true), gettype($attributeDescription)), __LINE__);
        }
        if (is_null($attributeDescription) || (is_array($attributeDescription) && empty($attributeDescription))) {
            unset($this->AttributeDescription);
        } else {
            $this->AttributeDescription = $attributeDescription;
        }
        return $this;
    }
    /**
     * Get AttributeId value
     * @return int|null
     */
    public function getAttributeId()
    {
        return $this->AttributeId;
    }
    /**
     * Set AttributeId value
     * @param int $attributeId
     * @return \StructType\SeatAttributeDisplay
     */
    public function setAttributeId($attributeId = null)
    {
        // validation for constraint: int
        if (!is_null($attributeId) && !(is_int($attributeId) || ctype_digit($attributeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeId, true), gettype($attributeId)), __LINE__);
        }
        $this->AttributeId = $attributeId;
        return $this;
    }
    /**
     * Get AttributeOrder value
     * @return int|null
     */
    public function getAttributeOrder()
    {
        return $this->AttributeOrder;
    }
    /**
     * Set AttributeOrder value
     * @param int $attributeOrder
     * @return \StructType\SeatAttributeDisplay
     */
    public function setAttributeOrder($attributeOrder = null)
    {
        // validation for constraint: int
        if (!is_null($attributeOrder) && !(is_int($attributeOrder) || ctype_digit($attributeOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeOrder, true), gettype($attributeOrder)), __LINE__);
        }
        $this->AttributeOrder = $attributeOrder;
        return $this;
    }
    /**
     * Get IsCommercial value
     * @return bool|null
     */
    public function getIsCommercial()
    {
        return $this->IsCommercial;
    }
    /**
     * Set IsCommercial value
     * @param bool $isCommercial
     * @return \StructType\SeatAttributeDisplay
     */
    public function setIsCommercial($isCommercial = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommercial) && !is_bool($isCommercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommercial, true), gettype($isCommercial)), __LINE__);
        }
        $this->IsCommercial = $isCommercial;
        return $this;
    }
    /**
     * Get IsMarketing value
     * @return bool|null
     */
    public function getIsMarketing()
    {
        return $this->IsMarketing;
    }
    /**
     * Set IsMarketing value
     * @param bool $isMarketing
     * @return \StructType\SeatAttributeDisplay
     */
    public function setIsMarketing($isMarketing = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketing) && !is_bool($isMarketing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarketing, true), gettype($isMarketing)), __LINE__);
        }
        $this->IsMarketing = $isMarketing;
        return $this;
    }
    /**
     * Get IsOperational value
     * @return bool|null
     */
    public function getIsOperational()
    {
        return $this->IsOperational;
    }
    /**
     * Set IsOperational value
     * @param bool $isOperational
     * @return \StructType\SeatAttributeDisplay
     */
    public function setIsOperational($isOperational = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOperational) && !is_bool($isOperational)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOperational, true), gettype($isOperational)), __LINE__);
        }
        $this->IsOperational = $isOperational;
        return $this;
    }
    /**
     * Get SystemAttribute value
     * @return bool|null
     */
    public function getSystemAttribute()
    {
        return $this->SystemAttribute;
    }
    /**
     * Set SystemAttribute value
     * @param bool $systemAttribute
     * @return \StructType\SeatAttributeDisplay
     */
    public function setSystemAttribute($systemAttribute = null)
    {
        // validation for constraint: boolean
        if (!is_null($systemAttribute) && !is_bool($systemAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($systemAttribute, true), gettype($systemAttribute)), __LINE__);
        }
        $this->SystemAttribute = $systemAttribute;
        return $this;
    }
}
