<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RuleBase
 * @subpackage Structs
 */
class RuleBase extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleCode;
    /**
     * Constructor method for RuleBase
     * @uses RuleBase::setDescription()
     * @uses RuleBase::setReasonCode()
     * @uses RuleBase::setRuleCode()
     * @param string $description
     * @param string $reasonCode
     * @param string $ruleCode
     */
    public function __construct($description = null, $reasonCode = null, $ruleCode = null)
    {
        $this
            ->setDescription($description)
            ->setReasonCode($reasonCode)
            ->setRuleCode($ruleCode);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\RuleBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \StructType\RuleBase
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get RuleCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleCode()
    {
        return isset($this->RuleCode) ? $this->RuleCode : null;
    }
    /**
     * Set RuleCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleCode
     * @return \StructType\RuleBase
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        if (is_null($ruleCode) || (is_array($ruleCode) && empty($ruleCode))) {
            unset($this->RuleCode);
        } else {
            $this->RuleCode = $ruleCode;
        }
        return $this;
    }
}
