<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveLogicalFlightInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveLogicalFlightInfo
 * @subpackage Structs
 */
class RetrieveLogicalFlightInfo extends TransactionInfo
{
    /**
     * The RetrieveLogicalFlightInfoRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveLogicalFlightInfo
     */
    public $RetrieveLogicalFlightInfoRequest;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * Constructor method for RetrieveLogicalFlightInfo
     * @uses RetrieveLogicalFlightInfo::setRetrieveLogicalFlightInfoRequest()
     * @uses RetrieveLogicalFlightInfo::setDepartureDate()
     * @uses RetrieveLogicalFlightInfo::setDestination()
     * @uses RetrieveLogicalFlightInfo::setFlightNumber()
     * @uses RetrieveLogicalFlightInfo::setOrigin()
     * @param \StructType\RetrieveLogicalFlightInfo $retrieveLogicalFlightInfoRequest
     * @param string $departureDate
     * @param string $destination
     * @param string $flightNumber
     * @param string $origin
     */
    public function __construct(\StructType\RetrieveLogicalFlightInfo $retrieveLogicalFlightInfoRequest = null, $departureDate = null, $destination = null, $flightNumber = null, $origin = null)
    {
        $this
            ->setRetrieveLogicalFlightInfoRequest($retrieveLogicalFlightInfoRequest)
            ->setDepartureDate($departureDate)
            ->setDestination($destination)
            ->setFlightNumber($flightNumber)
            ->setOrigin($origin);
    }
    /**
     * Get RetrieveLogicalFlightInfoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveLogicalFlightInfo|null
     */
    public function getRetrieveLogicalFlightInfoRequest()
    {
        return isset($this->RetrieveLogicalFlightInfoRequest) ? $this->RetrieveLogicalFlightInfoRequest : null;
    }
    /**
     * Set RetrieveLogicalFlightInfoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveLogicalFlightInfo $retrieveLogicalFlightInfoRequest
     * @return \StructType\RetrieveLogicalFlightInfo
     */
    public function setRetrieveLogicalFlightInfoRequest(\StructType\RetrieveLogicalFlightInfo $retrieveLogicalFlightInfoRequest = null)
    {
        if (is_null($retrieveLogicalFlightInfoRequest) || (is_array($retrieveLogicalFlightInfoRequest) && empty($retrieveLogicalFlightInfoRequest))) {
            unset($this->RetrieveLogicalFlightInfoRequest);
        } else {
            $this->RetrieveLogicalFlightInfoRequest = $retrieveLogicalFlightInfoRequest;
        }
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrieveLogicalFlightInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\RetrieveLogicalFlightInfo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\RetrieveLogicalFlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\RetrieveLogicalFlightInfo
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
}
