<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailCar StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RailCar
 * @subpackage Structs
 */
class RailCar extends AbstractStructBase
{
    /**
     * The CabinClasses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCabinClassDisplay
     */
    public $CabinClasses;
    /**
     * The Decks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDeckDisplay
     */
    public $Decks;
    /**
     * The RailCarID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RailCarID;
    /**
     * The RailCarSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RailCarSequence;
    /**
     * The SeatCabins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatCabinDisplay
     */
    public $SeatCabins;
    /**
     * The SeatConfigId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatConfigId;
    /**
     * The SeatConfiguration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SeatConfigurationDisplay
     */
    public $SeatConfiguration;
    /**
     * The TrainConfigId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrainConfigId;
    /**
     * Constructor method for RailCar
     * @uses RailCar::setCabinClasses()
     * @uses RailCar::setDecks()
     * @uses RailCar::setRailCarID()
     * @uses RailCar::setRailCarSequence()
     * @uses RailCar::setSeatCabins()
     * @uses RailCar::setSeatConfigId()
     * @uses RailCar::setSeatConfiguration()
     * @uses RailCar::setTrainConfigId()
     * @param \ArrayType\ArrayOfCabinClassDisplay $cabinClasses
     * @param \ArrayType\ArrayOfDeckDisplay $decks
     * @param int $railCarID
     * @param int $railCarSequence
     * @param \ArrayType\ArrayOfSeatCabinDisplay $seatCabins
     * @param int $seatConfigId
     * @param \StructType\SeatConfigurationDisplay $seatConfiguration
     * @param int $trainConfigId
     */
    public function __construct(\ArrayType\ArrayOfCabinClassDisplay $cabinClasses = null, \ArrayType\ArrayOfDeckDisplay $decks = null, $railCarID = null, $railCarSequence = null, \ArrayType\ArrayOfSeatCabinDisplay $seatCabins = null, $seatConfigId = null, \StructType\SeatConfigurationDisplay $seatConfiguration = null, $trainConfigId = null)
    {
        $this
            ->setCabinClasses($cabinClasses)
            ->setDecks($decks)
            ->setRailCarID($railCarID)
            ->setRailCarSequence($railCarSequence)
            ->setSeatCabins($seatCabins)
            ->setSeatConfigId($seatConfigId)
            ->setSeatConfiguration($seatConfiguration)
            ->setTrainConfigId($trainConfigId);
    }
    /**
     * Get CabinClasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCabinClassDisplay|null
     */
    public function getCabinClasses()
    {
        return isset($this->CabinClasses) ? $this->CabinClasses : null;
    }
    /**
     * Set CabinClasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCabinClassDisplay $cabinClasses
     * @return \StructType\RailCar
     */
    public function setCabinClasses(\ArrayType\ArrayOfCabinClassDisplay $cabinClasses = null)
    {
        if (is_null($cabinClasses) || (is_array($cabinClasses) && empty($cabinClasses))) {
            unset($this->CabinClasses);
        } else {
            $this->CabinClasses = $cabinClasses;
        }
        return $this;
    }
    /**
     * Get Decks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDeckDisplay|null
     */
    public function getDecks()
    {
        return isset($this->Decks) ? $this->Decks : null;
    }
    /**
     * Set Decks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDeckDisplay $decks
     * @return \StructType\RailCar
     */
    public function setDecks(\ArrayType\ArrayOfDeckDisplay $decks = null)
    {
        if (is_null($decks) || (is_array($decks) && empty($decks))) {
            unset($this->Decks);
        } else {
            $this->Decks = $decks;
        }
        return $this;
    }
    /**
     * Get RailCarID value
     * @return int|null
     */
    public function getRailCarID()
    {
        return $this->RailCarID;
    }
    /**
     * Set RailCarID value
     * @param int $railCarID
     * @return \StructType\RailCar
     */
    public function setRailCarID($railCarID = null)
    {
        // validation for constraint: int
        if (!is_null($railCarID) && !(is_int($railCarID) || ctype_digit($railCarID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarID, true), gettype($railCarID)), __LINE__);
        }
        $this->RailCarID = $railCarID;
        return $this;
    }
    /**
     * Get RailCarSequence value
     * @return int|null
     */
    public function getRailCarSequence()
    {
        return $this->RailCarSequence;
    }
    /**
     * Set RailCarSequence value
     * @param int $railCarSequence
     * @return \StructType\RailCar
     */
    public function setRailCarSequence($railCarSequence = null)
    {
        // validation for constraint: int
        if (!is_null($railCarSequence) && !(is_int($railCarSequence) || ctype_digit($railCarSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarSequence, true), gettype($railCarSequence)), __LINE__);
        }
        $this->RailCarSequence = $railCarSequence;
        return $this;
    }
    /**
     * Get SeatCabins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatCabinDisplay|null
     */
    public function getSeatCabins()
    {
        return isset($this->SeatCabins) ? $this->SeatCabins : null;
    }
    /**
     * Set SeatCabins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatCabinDisplay $seatCabins
     * @return \StructType\RailCar
     */
    public function setSeatCabins(\ArrayType\ArrayOfSeatCabinDisplay $seatCabins = null)
    {
        if (is_null($seatCabins) || (is_array($seatCabins) && empty($seatCabins))) {
            unset($this->SeatCabins);
        } else {
            $this->SeatCabins = $seatCabins;
        }
        return $this;
    }
    /**
     * Get SeatConfigId value
     * @return int|null
     */
    public function getSeatConfigId()
    {
        return $this->SeatConfigId;
    }
    /**
     * Set SeatConfigId value
     * @param int $seatConfigId
     * @return \StructType\RailCar
     */
    public function setSeatConfigId($seatConfigId = null)
    {
        // validation for constraint: int
        if (!is_null($seatConfigId) && !(is_int($seatConfigId) || ctype_digit($seatConfigId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatConfigId, true), gettype($seatConfigId)), __LINE__);
        }
        $this->SeatConfigId = $seatConfigId;
        return $this;
    }
    /**
     * Get SeatConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SeatConfigurationDisplay|null
     */
    public function getSeatConfiguration()
    {
        return isset($this->SeatConfiguration) ? $this->SeatConfiguration : null;
    }
    /**
     * Set SeatConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SeatConfigurationDisplay $seatConfiguration
     * @return \StructType\RailCar
     */
    public function setSeatConfiguration(\StructType\SeatConfigurationDisplay $seatConfiguration = null)
    {
        if (is_null($seatConfiguration) || (is_array($seatConfiguration) && empty($seatConfiguration))) {
            unset($this->SeatConfiguration);
        } else {
            $this->SeatConfiguration = $seatConfiguration;
        }
        return $this;
    }
    /**
     * Get TrainConfigId value
     * @return int|null
     */
    public function getTrainConfigId()
    {
        return $this->TrainConfigId;
    }
    /**
     * Set TrainConfigId value
     * @param int $trainConfigId
     * @return \StructType\RailCar
     */
    public function setTrainConfigId($trainConfigId = null)
    {
        // validation for constraint: int
        if (!is_null($trainConfigId) && !(is_int($trainConfigId) || ctype_digit($trainConfigId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trainConfigId, true), gettype($trainConfigId)), __LINE__);
        }
        $this->TrainConfigId = $trainConfigId;
        return $this;
    }
}
