<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalTrainMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalTrainMap
 * @subpackage Structs
 */
class PhysicalTrainMap extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationName;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginName;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The RailCars
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRailCar
     */
    public $RailCars;
    /**
     * The TrainNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrainNumber;
    /**
     * Constructor method for PhysicalTrainMap
     * @uses PhysicalTrainMap::setDepartureDate()
     * @uses PhysicalTrainMap::setDestination()
     * @uses PhysicalTrainMap::setDestinationName()
     * @uses PhysicalTrainMap::setOrigin()
     * @uses PhysicalTrainMap::setOriginName()
     * @uses PhysicalTrainMap::setPhysicalFlightID()
     * @uses PhysicalTrainMap::setRailCars()
     * @uses PhysicalTrainMap::setTrainNumber()
     * @param string $departureDate
     * @param string $destination
     * @param string $destinationName
     * @param string $origin
     * @param string $originName
     * @param int $physicalFlightID
     * @param \ArrayType\ArrayOfRailCar $railCars
     * @param string $trainNumber
     */
    public function __construct($departureDate = null, $destination = null, $destinationName = null, $origin = null, $originName = null, $physicalFlightID = null, \ArrayType\ArrayOfRailCar $railCars = null, $trainNumber = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setDestination($destination)
            ->setDestinationName($destinationName)
            ->setOrigin($origin)
            ->setOriginName($originName)
            ->setPhysicalFlightID($physicalFlightID)
            ->setRailCars($railCars)
            ->setTrainNumber($trainNumber);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PhysicalTrainMap
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\PhysicalTrainMap
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get DestinationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationName()
    {
        return isset($this->DestinationName) ? $this->DestinationName : null;
    }
    /**
     * Set DestinationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationName
     * @return \StructType\PhysicalTrainMap
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        if (is_null($destinationName) || (is_array($destinationName) && empty($destinationName))) {
            unset($this->DestinationName);
        } else {
            $this->DestinationName = $destinationName;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\PhysicalTrainMap
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get OriginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginName()
    {
        return isset($this->OriginName) ? $this->OriginName : null;
    }
    /**
     * Set OriginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originName
     * @return \StructType\PhysicalTrainMap
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        if (is_null($originName) || (is_array($originName) && empty($originName))) {
            unset($this->OriginName);
        } else {
            $this->OriginName = $originName;
        }
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\PhysicalTrainMap
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get RailCars value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRailCar|null
     */
    public function getRailCars()
    {
        return isset($this->RailCars) ? $this->RailCars : null;
    }
    /**
     * Set RailCars value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRailCar $railCars
     * @return \StructType\PhysicalTrainMap
     */
    public function setRailCars(\ArrayType\ArrayOfRailCar $railCars = null)
    {
        if (is_null($railCars) || (is_array($railCars) && empty($railCars))) {
            unset($this->RailCars);
        } else {
            $this->RailCars = $railCars;
        }
        return $this;
    }
    /**
     * Get TrainNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrainNumber()
    {
        return isset($this->TrainNumber) ? $this->TrainNumber : null;
    }
    /**
     * Set TrainNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trainNumber
     * @return \StructType\PhysicalTrainMap
     */
    public function setTrainNumber($trainNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trainNumber) && !is_string($trainNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trainNumber, true), gettype($trainNumber)), __LINE__);
        }
        if (is_null($trainNumber) || (is_array($trainNumber) && empty($trainNumber))) {
            unset($this->TrainNumber);
        } else {
            $this->TrainNumber = $trainNumber;
        }
        return $this;
    }
}
