<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalFlightSeatMapInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalFlightSeatMapInfo
 * @subpackage Structs
 */
class PhysicalFlightSeatMapInfo extends AbstractStructBase
{
    /**
     * The CabinClasses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCabinClassDisplay
     */
    public $CabinClasses;
    /**
     * The Decks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDeckDisplay
     */
    public $Decks;
    /**
     * The SeatCabins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatCabinDisplay
     */
    public $SeatCabins;
    /**
     * The SeatConfiguration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SeatConfigurationDisplay
     */
    public $SeatConfiguration;
    /**
     * The SeatWBZones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatWBZoneDisplay
     */
    public $SeatWBZones;
    /**
     * Constructor method for PhysicalFlightSeatMapInfo
     * @uses PhysicalFlightSeatMapInfo::setCabinClasses()
     * @uses PhysicalFlightSeatMapInfo::setDecks()
     * @uses PhysicalFlightSeatMapInfo::setSeatCabins()
     * @uses PhysicalFlightSeatMapInfo::setSeatConfiguration()
     * @uses PhysicalFlightSeatMapInfo::setSeatWBZones()
     * @param \ArrayType\ArrayOfCabinClassDisplay $cabinClasses
     * @param \ArrayType\ArrayOfDeckDisplay $decks
     * @param \ArrayType\ArrayOfSeatCabinDisplay $seatCabins
     * @param \StructType\SeatConfigurationDisplay $seatConfiguration
     * @param \ArrayType\ArrayOfSeatWBZoneDisplay $seatWBZones
     */
    public function __construct(\ArrayType\ArrayOfCabinClassDisplay $cabinClasses = null, \ArrayType\ArrayOfDeckDisplay $decks = null, \ArrayType\ArrayOfSeatCabinDisplay $seatCabins = null, \StructType\SeatConfigurationDisplay $seatConfiguration = null, \ArrayType\ArrayOfSeatWBZoneDisplay $seatWBZones = null)
    {
        $this
            ->setCabinClasses($cabinClasses)
            ->setDecks($decks)
            ->setSeatCabins($seatCabins)
            ->setSeatConfiguration($seatConfiguration)
            ->setSeatWBZones($seatWBZones);
    }
    /**
     * Get CabinClasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCabinClassDisplay|null
     */
    public function getCabinClasses()
    {
        return isset($this->CabinClasses) ? $this->CabinClasses : null;
    }
    /**
     * Set CabinClasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCabinClassDisplay $cabinClasses
     * @return \StructType\PhysicalFlightSeatMapInfo
     */
    public function setCabinClasses(\ArrayType\ArrayOfCabinClassDisplay $cabinClasses = null)
    {
        if (is_null($cabinClasses) || (is_array($cabinClasses) && empty($cabinClasses))) {
            unset($this->CabinClasses);
        } else {
            $this->CabinClasses = $cabinClasses;
        }
        return $this;
    }
    /**
     * Get Decks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDeckDisplay|null
     */
    public function getDecks()
    {
        return isset($this->Decks) ? $this->Decks : null;
    }
    /**
     * Set Decks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDeckDisplay $decks
     * @return \StructType\PhysicalFlightSeatMapInfo
     */
    public function setDecks(\ArrayType\ArrayOfDeckDisplay $decks = null)
    {
        if (is_null($decks) || (is_array($decks) && empty($decks))) {
            unset($this->Decks);
        } else {
            $this->Decks = $decks;
        }
        return $this;
    }
    /**
     * Get SeatCabins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatCabinDisplay|null
     */
    public function getSeatCabins()
    {
        return isset($this->SeatCabins) ? $this->SeatCabins : null;
    }
    /**
     * Set SeatCabins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatCabinDisplay $seatCabins
     * @return \StructType\PhysicalFlightSeatMapInfo
     */
    public function setSeatCabins(\ArrayType\ArrayOfSeatCabinDisplay $seatCabins = null)
    {
        if (is_null($seatCabins) || (is_array($seatCabins) && empty($seatCabins))) {
            unset($this->SeatCabins);
        } else {
            $this->SeatCabins = $seatCabins;
        }
        return $this;
    }
    /**
     * Get SeatConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SeatConfigurationDisplay|null
     */
    public function getSeatConfiguration()
    {
        return isset($this->SeatConfiguration) ? $this->SeatConfiguration : null;
    }
    /**
     * Set SeatConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SeatConfigurationDisplay $seatConfiguration
     * @return \StructType\PhysicalFlightSeatMapInfo
     */
    public function setSeatConfiguration(\StructType\SeatConfigurationDisplay $seatConfiguration = null)
    {
        if (is_null($seatConfiguration) || (is_array($seatConfiguration) && empty($seatConfiguration))) {
            unset($this->SeatConfiguration);
        } else {
            $this->SeatConfiguration = $seatConfiguration;
        }
        return $this;
    }
    /**
     * Get SeatWBZones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatWBZoneDisplay|null
     */
    public function getSeatWBZones()
    {
        return isset($this->SeatWBZones) ? $this->SeatWBZones : null;
    }
    /**
     * Set SeatWBZones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatWBZoneDisplay $seatWBZones
     * @return \StructType\PhysicalFlightSeatMapInfo
     */
    public function setSeatWBZones(\ArrayType\ArrayOfSeatWBZoneDisplay $seatWBZones = null)
    {
        if (is_null($seatWBZones) || (is_array($seatWBZones) && empty($seatWBZones))) {
            unset($this->SeatWBZones);
        } else {
            $this->SeatWBZones = $seatWBZones;
        }
        return $this;
    }
}
