<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalFlightMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalFlightMap
 * @subpackage Structs
 */
class PhysicalFlightMap extends AbstractStructBase
{
    /**
     * The PhysicalFlightID
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginName;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationName;
    /**
     * The FlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNum;
    /**
     * The PhysicalFlightSeatMap
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PhysicalFlightSeatMapInfo
     */
    public $PhysicalFlightSeatMap;
    /**
     * Constructor method for PhysicalFlightMap
     * @uses PhysicalFlightMap::setPhysicalFlightID()
     * @uses PhysicalFlightMap::setDepartureDate()
     * @uses PhysicalFlightMap::setOrigin()
     * @uses PhysicalFlightMap::setDestination()
     * @uses PhysicalFlightMap::setOriginName()
     * @uses PhysicalFlightMap::setDestinationName()
     * @uses PhysicalFlightMap::setFlightNum()
     * @uses PhysicalFlightMap::setPhysicalFlightSeatMap()
     * @param int $physicalFlightID
     * @param string $departureDate
     * @param string $origin
     * @param string $destination
     * @param string $originName
     * @param string $destinationName
     * @param string $flightNum
     * @param \StructType\PhysicalFlightSeatMapInfo $physicalFlightSeatMap
     */
    public function __construct($physicalFlightID = null, $departureDate = null, $origin = null, $destination = null, $originName = null, $destinationName = null, $flightNum = null, \StructType\PhysicalFlightSeatMapInfo $physicalFlightSeatMap = null)
    {
        $this
            ->setPhysicalFlightID($physicalFlightID)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setOriginName($originName)
            ->setDestinationName($destinationName)
            ->setFlightNum($flightNum)
            ->setPhysicalFlightSeatMap($physicalFlightSeatMap);
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\PhysicalFlightMap
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PhysicalFlightMap
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\PhysicalFlightMap
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\PhysicalFlightMap
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get OriginName value
     * @return string|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param string $originName
     * @return \StructType\PhysicalFlightMap
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\PhysicalFlightMap
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get FlightNum value
     * @return string|null
     */
    public function getFlightNum()
    {
        return $this->FlightNum;
    }
    /**
     * Set FlightNum value
     * @param string $flightNum
     * @return \StructType\PhysicalFlightMap
     */
    public function setFlightNum($flightNum = null)
    {
        // validation for constraint: string
        if (!is_null($flightNum) && !is_string($flightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNum, true), gettype($flightNum)), __LINE__);
        }
        $this->FlightNum = $flightNum;
        return $this;
    }
    /**
     * Get PhysicalFlightSeatMap value
     * @return \StructType\PhysicalFlightSeatMapInfo|null
     */
    public function getPhysicalFlightSeatMap()
    {
        return $this->PhysicalFlightSeatMap;
    }
    /**
     * Set PhysicalFlightSeatMap value
     * @param \StructType\PhysicalFlightSeatMapInfo $physicalFlightSeatMap
     * @return \StructType\PhysicalFlightMap
     */
    public function setPhysicalFlightSeatMap(\StructType\PhysicalFlightSeatMapInfo $physicalFlightSeatMap = null)
    {
        $this->PhysicalFlightSeatMap = $physicalFlightSeatMap;
        return $this;
    }
}
