<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MIAPSR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MIAPSR
 * @subpackage Structs
 */
class MIAPSR extends RuleBase
{
    /**
     * The MaxInfantAllowedPerRow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxInfantAllowedPerRow;
    /**
     * Constructor method for MIAPSR
     * @uses MIAPSR::setMaxInfantAllowedPerRow()
     * @param int $maxInfantAllowedPerRow
     */
    public function __construct($maxInfantAllowedPerRow = null)
    {
        $this
            ->setMaxInfantAllowedPerRow($maxInfantAllowedPerRow);
    }
    /**
     * Get MaxInfantAllowedPerRow value
     * @return int|null
     */
    public function getMaxInfantAllowedPerRow()
    {
        return $this->MaxInfantAllowedPerRow;
    }
    /**
     * Set MaxInfantAllowedPerRow value
     * @param int $maxInfantAllowedPerRow
     * @return \StructType\MIAPSR
     */
    public function setMaxInfantAllowedPerRow($maxInfantAllowedPerRow = null)
    {
        // validation for constraint: int
        if (!is_null($maxInfantAllowedPerRow) && !(is_int($maxInfantAllowedPerRow) || ctype_digit($maxInfantAllowedPerRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxInfantAllowedPerRow, true), gettype($maxInfantAllowedPerRow)), __LINE__);
        }
        $this->MaxInfantAllowedPerRow = $maxInfantAllowedPerRow;
        return $this;
    }
}
