<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Legdetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Legdetails
 * @subpackage Structs
 */
class Legdetails extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Carrier;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FromAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FromAirport;
    /**
     * The ToAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ToAirport;
    /**
     * The ScheduledDepature
     * @var string
     */
    public $ScheduledDepature;
    /**
     * The ScheduledArrival
     * @var string
     */
    public $ScheduledArrival;
    /**
     * The EstimatedDeparture
     * @var string
     */
    public $EstimatedDeparture;
    /**
     * The EstimatedArrival
     * @var string
     */
    public $EstimatedArrival;
    /**
     * The FlightStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightStatus;
    /**
     * Constructor method for Legdetails
     * @uses Legdetails::setCarrier()
     * @uses Legdetails::setFlightNumber()
     * @uses Legdetails::setFromAirport()
     * @uses Legdetails::setToAirport()
     * @uses Legdetails::setScheduledDepature()
     * @uses Legdetails::setScheduledArrival()
     * @uses Legdetails::setEstimatedDeparture()
     * @uses Legdetails::setEstimatedArrival()
     * @uses Legdetails::setFlightStatus()
     * @param string $carrier
     * @param string $flightNumber
     * @param string $fromAirport
     * @param string $toAirport
     * @param string $scheduledDepature
     * @param string $scheduledArrival
     * @param string $estimatedDeparture
     * @param string $estimatedArrival
     * @param string $flightStatus
     */
    public function __construct($carrier = null, $flightNumber = null, $fromAirport = null, $toAirport = null, $scheduledDepature = null, $scheduledArrival = null, $estimatedDeparture = null, $estimatedArrival = null, $flightStatus = null)
    {
        $this
            ->setCarrier($carrier)
            ->setFlightNumber($flightNumber)
            ->setFromAirport($fromAirport)
            ->setToAirport($toAirport)
            ->setScheduledDepature($scheduledDepature)
            ->setScheduledArrival($scheduledArrival)
            ->setEstimatedDeparture($estimatedDeparture)
            ->setEstimatedArrival($estimatedArrival)
            ->setFlightStatus($flightStatus);
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \StructType\Legdetails
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\Legdetails
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get FromAirport value
     * @return string|null
     */
    public function getFromAirport()
    {
        return $this->FromAirport;
    }
    /**
     * Set FromAirport value
     * @param string $fromAirport
     * @return \StructType\Legdetails
     */
    public function setFromAirport($fromAirport = null)
    {
        // validation for constraint: string
        if (!is_null($fromAirport) && !is_string($fromAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAirport, true), gettype($fromAirport)), __LINE__);
        }
        $this->FromAirport = $fromAirport;
        return $this;
    }
    /**
     * Get ToAirport value
     * @return string|null
     */
    public function getToAirport()
    {
        return $this->ToAirport;
    }
    /**
     * Set ToAirport value
     * @param string $toAirport
     * @return \StructType\Legdetails
     */
    public function setToAirport($toAirport = null)
    {
        // validation for constraint: string
        if (!is_null($toAirport) && !is_string($toAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAirport, true), gettype($toAirport)), __LINE__);
        }
        $this->ToAirport = $toAirport;
        return $this;
    }
    /**
     * Get ScheduledDepature value
     * @return string|null
     */
    public function getScheduledDepature()
    {
        return $this->ScheduledDepature;
    }
    /**
     * Set ScheduledDepature value
     * @param string $scheduledDepature
     * @return \StructType\Legdetails
     */
    public function setScheduledDepature($scheduledDepature = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDepature) && !is_string($scheduledDepature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledDepature, true), gettype($scheduledDepature)), __LINE__);
        }
        $this->ScheduledDepature = $scheduledDepature;
        return $this;
    }
    /**
     * Get ScheduledArrival value
     * @return string|null
     */
    public function getScheduledArrival()
    {
        return $this->ScheduledArrival;
    }
    /**
     * Set ScheduledArrival value
     * @param string $scheduledArrival
     * @return \StructType\Legdetails
     */
    public function setScheduledArrival($scheduledArrival = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledArrival) && !is_string($scheduledArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledArrival, true), gettype($scheduledArrival)), __LINE__);
        }
        $this->ScheduledArrival = $scheduledArrival;
        return $this;
    }
    /**
     * Get EstimatedDeparture value
     * @return string|null
     */
    public function getEstimatedDeparture()
    {
        return $this->EstimatedDeparture;
    }
    /**
     * Set EstimatedDeparture value
     * @param string $estimatedDeparture
     * @return \StructType\Legdetails
     */
    public function setEstimatedDeparture($estimatedDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeparture) && !is_string($estimatedDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeparture, true), gettype($estimatedDeparture)), __LINE__);
        }
        $this->EstimatedDeparture = $estimatedDeparture;
        return $this;
    }
    /**
     * Get EstimatedArrival value
     * @return string|null
     */
    public function getEstimatedArrival()
    {
        return $this->EstimatedArrival;
    }
    /**
     * Set EstimatedArrival value
     * @param string $estimatedArrival
     * @return \StructType\Legdetails
     */
    public function setEstimatedArrival($estimatedArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedArrival) && !is_string($estimatedArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedArrival, true), gettype($estimatedArrival)), __LINE__);
        }
        $this->EstimatedArrival = $estimatedArrival;
        return $this;
    }
    /**
     * Get FlightStatus value
     * @return string|null
     */
    public function getFlightStatus()
    {
        return $this->FlightStatus;
    }
    /**
     * Set FlightStatus value
     * @param string $flightStatus
     * @return \StructType\Legdetails
     */
    public function setFlightStatus($flightStatus = null)
    {
        // validation for constraint: string
        if (!is_null($flightStatus) && !is_string($flightStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightStatus, true), gettype($flightStatus)), __LINE__);
        }
        $this->FlightStatus = $flightStatus;
        return $this;
    }
}
