<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightDetails
 * @subpackage Structs
 */
class FlightDetails extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ActiveOnly
     * @var bool
     */
    public $ActiveOnly;
    /**
     * Constructor method for FlightDetails
     * @uses FlightDetails::setOrigin()
     * @uses FlightDetails::setDestination()
     * @uses FlightDetails::setFlightNumber()
     * @uses FlightDetails::setDepartureDate()
     * @uses FlightDetails::setActiveOnly()
     * @param string $origin
     * @param string $destination
     * @param string $flightNumber
     * @param string $departureDate
     * @param bool $activeOnly
     */
    public function __construct($origin = null, $destination = null, $flightNumber = null, $departureDate = null, $activeOnly = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setFlightNumber($flightNumber)
            ->setDepartureDate($departureDate)
            ->setActiveOnly($activeOnly);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\FlightDetails
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\FlightDetails
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightDetails
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\FlightDetails
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ActiveOnly value
     * @return bool|null
     */
    public function getActiveOnly()
    {
        return $this->ActiveOnly;
    }
    /**
     * Set ActiveOnly value
     * @param bool $activeOnly
     * @return \StructType\FlightDetails
     */
    public function setActiveOnly($activeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeOnly) && !is_bool($activeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeOnly, true), gettype($activeOnly)), __LINE__);
        }
        $this->ActiveOnly = $activeOnly;
        return $this;
    }
}
