<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeckDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeckDisplay
 * @subpackage Structs
 */
class DeckDisplay extends AbstractStructBase
{
    /**
     * The DeckCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeckCode;
    /**
     * The DeckId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeckId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for DeckDisplay
     * @uses DeckDisplay::setDeckCode()
     * @uses DeckDisplay::setDeckId()
     * @uses DeckDisplay::setDescription()
     * @param string $deckCode
     * @param int $deckId
     * @param string $description
     */
    public function __construct($deckCode = null, $deckId = null, $description = null)
    {
        $this
            ->setDeckCode($deckCode)
            ->setDeckId($deckId)
            ->setDescription($description);
    }
    /**
     * Get DeckCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeckCode()
    {
        return isset($this->DeckCode) ? $this->DeckCode : null;
    }
    /**
     * Set DeckCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deckCode
     * @return \StructType\DeckDisplay
     */
    public function setDeckCode($deckCode = null)
    {
        // validation for constraint: string
        if (!is_null($deckCode) && !is_string($deckCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deckCode, true), gettype($deckCode)), __LINE__);
        }
        if (is_null($deckCode) || (is_array($deckCode) && empty($deckCode))) {
            unset($this->DeckCode);
        } else {
            $this->DeckCode = $deckCode;
        }
        return $this;
    }
    /**
     * Get DeckId value
     * @return int|null
     */
    public function getDeckId()
    {
        return $this->DeckId;
    }
    /**
     * Set DeckId value
     * @param int $deckId
     * @return \StructType\DeckDisplay
     */
    public function setDeckId($deckId = null)
    {
        // validation for constraint: int
        if (!is_null($deckId) && !(is_int($deckId) || ctype_digit($deckId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deckId, true), gettype($deckId)), __LINE__);
        }
        $this->DeckId = $deckId;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\DeckDisplay
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
