<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cabin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Cabin
 * @subpackage Structs
 */
class Cabin extends AbstractStructBase
{
    /**
     * The CabinName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CabinName;
    /**
     * The SeatMaps
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatMap
     */
    public $SeatMaps;
    /**
     * The SeatAssignments
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatAssignment
     */
    public $SeatAssignments;
    /**
     * The SeatExceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatException
     */
    public $SeatExceptions;
    /**
     * The SeatCharges
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatCharge
     */
    public $SeatCharges;
    /**
     * Constructor method for Cabin
     * @uses Cabin::setCabinName()
     * @uses Cabin::setSeatMaps()
     * @uses Cabin::setSeatAssignments()
     * @uses Cabin::setSeatExceptions()
     * @uses Cabin::setSeatCharges()
     * @param string $cabinName
     * @param \ArrayType\ArrayOfSeatMap $seatMaps
     * @param \ArrayType\ArrayOfSeatAssignment $seatAssignments
     * @param \ArrayType\ArrayOfSeatException $seatExceptions
     * @param \ArrayType\ArrayOfSeatCharge $seatCharges
     */
    public function __construct($cabinName = null, \ArrayType\ArrayOfSeatMap $seatMaps = null, \ArrayType\ArrayOfSeatAssignment $seatAssignments = null, \ArrayType\ArrayOfSeatException $seatExceptions = null, \ArrayType\ArrayOfSeatCharge $seatCharges = null)
    {
        $this
            ->setCabinName($cabinName)
            ->setSeatMaps($seatMaps)
            ->setSeatAssignments($seatAssignments)
            ->setSeatExceptions($seatExceptions)
            ->setSeatCharges($seatCharges);
    }
    /**
     * Get CabinName value
     * @return string|null
     */
    public function getCabinName()
    {
        return $this->CabinName;
    }
    /**
     * Set CabinName value
     * @param string $cabinName
     * @return \StructType\Cabin
     */
    public function setCabinName($cabinName = null)
    {
        // validation for constraint: string
        if (!is_null($cabinName) && !is_string($cabinName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinName, true), gettype($cabinName)), __LINE__);
        }
        $this->CabinName = $cabinName;
        return $this;
    }
    /**
     * Get SeatMaps value
     * @return \ArrayType\ArrayOfSeatMap|null
     */
    public function getSeatMaps()
    {
        return $this->SeatMaps;
    }
    /**
     * Set SeatMaps value
     * @param \ArrayType\ArrayOfSeatMap $seatMaps
     * @return \StructType\Cabin
     */
    public function setSeatMaps(\ArrayType\ArrayOfSeatMap $seatMaps = null)
    {
        $this->SeatMaps = $seatMaps;
        return $this;
    }
    /**
     * Get SeatAssignments value
     * @return \ArrayType\ArrayOfSeatAssignment|null
     */
    public function getSeatAssignments()
    {
        return $this->SeatAssignments;
    }
    /**
     * Set SeatAssignments value
     * @param \ArrayType\ArrayOfSeatAssignment $seatAssignments
     * @return \StructType\Cabin
     */
    public function setSeatAssignments(\ArrayType\ArrayOfSeatAssignment $seatAssignments = null)
    {
        $this->SeatAssignments = $seatAssignments;
        return $this;
    }
    /**
     * Get SeatExceptions value
     * @return \ArrayType\ArrayOfSeatException|null
     */
    public function getSeatExceptions()
    {
        return $this->SeatExceptions;
    }
    /**
     * Set SeatExceptions value
     * @param \ArrayType\ArrayOfSeatException $seatExceptions
     * @return \StructType\Cabin
     */
    public function setSeatExceptions(\ArrayType\ArrayOfSeatException $seatExceptions = null)
    {
        $this->SeatExceptions = $seatExceptions;
        return $this;
    }
    /**
     * Get SeatCharges value
     * @return \ArrayType\ArrayOfSeatCharge|null
     */
    public function getSeatCharges()
    {
        return $this->SeatCharges;
    }
    /**
     * Set SeatCharges value
     * @param \ArrayType\ArrayOfSeatCharge $seatCharges
     * @return \StructType\Cabin
     */
    public function setSeatCharges(\ArrayType\ArrayOfSeatCharge $seatCharges = null)
    {
        $this->SeatCharges = $seatCharges;
        return $this;
    }
}
