<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookDateSearch StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookDateSearch
 * @subpackage Structs
 */
class BookDateSearch extends AbstractStructBase
{
    /**
     * The BookingType
     * @var string
     */
    public $BookingType;
    /**
     * The StartSearchDate
     * @var string
     */
    public $StartSearchDate;
    /**
     * The EndSearchDate
     * @var string
     */
    public $EndSearchDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * Constructor method for BookDateSearch
     * @uses BookDateSearch::setBookingType()
     * @uses BookDateSearch::setStartSearchDate()
     * @uses BookDateSearch::setEndSearchDate()
     * @uses BookDateSearch::setOrigin()
     * @uses BookDateSearch::setDestination()
     * @param string $bookingType
     * @param string $startSearchDate
     * @param string $endSearchDate
     * @param string $origin
     * @param string $destination
     */
    public function __construct($bookingType = null, $startSearchDate = null, $endSearchDate = null, $origin = null, $destination = null)
    {
        $this
            ->setBookingType($bookingType)
            ->setStartSearchDate($startSearchDate)
            ->setEndSearchDate($endSearchDate)
            ->setOrigin($origin)
            ->setDestination($destination);
    }
    /**
     * Get BookingType value
     * @return string|null
     */
    public function getBookingType()
    {
        return $this->BookingType;
    }
    /**
     * Set BookingType value
     * @uses \EnumType\BookDateSearch_BookingsType::valueIsValid()
     * @uses \EnumType\BookDateSearch_BookingsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingType
     * @return \StructType\BookDateSearch
     */
    public function setBookingType($bookingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BookDateSearch_BookingsType::valueIsValid($bookingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BookDateSearch_BookingsType', is_array($bookingType) ? implode(', ', $bookingType) : var_export($bookingType, true), implode(', ', \EnumType\BookDateSearch_BookingsType::getValidValues())), __LINE__);
        }
        $this->BookingType = $bookingType;
        return $this;
    }
    /**
     * Get StartSearchDate value
     * @return string|null
     */
    public function getStartSearchDate()
    {
        return $this->StartSearchDate;
    }
    /**
     * Set StartSearchDate value
     * @param string $startSearchDate
     * @return \StructType\BookDateSearch
     */
    public function setStartSearchDate($startSearchDate = null)
    {
        // validation for constraint: string
        if (!is_null($startSearchDate) && !is_string($startSearchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startSearchDate, true), gettype($startSearchDate)), __LINE__);
        }
        $this->StartSearchDate = $startSearchDate;
        return $this;
    }
    /**
     * Get EndSearchDate value
     * @return string|null
     */
    public function getEndSearchDate()
    {
        return $this->EndSearchDate;
    }
    /**
     * Set EndSearchDate value
     * @param string $endSearchDate
     * @return \StructType\BookDateSearch
     */
    public function setEndSearchDate($endSearchDate = null)
    {
        // validation for constraint: string
        if (!is_null($endSearchDate) && !is_string($endSearchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endSearchDate, true), gettype($endSearchDate)), __LINE__);
        }
        $this->EndSearchDate = $endSearchDate;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\BookDateSearch
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\BookDateSearch
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
}
