<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateInventoryAirCraftLid StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateInventoryAirCraftLid
 * @subpackage Structs
 */
class UpdateInventoryAirCraftLid extends TransactionInfo
{
    /**
     * The CabinValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinValue;
    /**
     * The DestinationAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportCode;
    /**
     * The FlightDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FlightDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The LidType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LidType;
    /**
     * The LidValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LidValue;
    /**
     * The OriginAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportCode;
    /**
     * Constructor method for UpdateInventoryAirCraftLid
     * @uses UpdateInventoryAirCraftLid::setCabinValue()
     * @uses UpdateInventoryAirCraftLid::setDestinationAirportCode()
     * @uses UpdateInventoryAirCraftLid::setFlightDate()
     * @uses UpdateInventoryAirCraftLid::setFlightNumber()
     * @uses UpdateInventoryAirCraftLid::setLidType()
     * @uses UpdateInventoryAirCraftLid::setLidValue()
     * @uses UpdateInventoryAirCraftLid::setOriginAirportCode()
     * @param string $cabinValue
     * @param string $destinationAirportCode
     * @param string $flightDate
     * @param string $flightNumber
     * @param string $lidType
     * @param int $lidValue
     * @param string $originAirportCode
     */
    public function __construct($cabinValue = null, $destinationAirportCode = null, $flightDate = null, $flightNumber = null, $lidType = null, $lidValue = null, $originAirportCode = null)
    {
        $this
            ->setCabinValue($cabinValue)
            ->setDestinationAirportCode($destinationAirportCode)
            ->setFlightDate($flightDate)
            ->setFlightNumber($flightNumber)
            ->setLidType($lidType)
            ->setLidValue($lidValue)
            ->setOriginAirportCode($originAirportCode);
    }
    /**
     * Get CabinValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinValue()
    {
        return isset($this->CabinValue) ? $this->CabinValue : null;
    }
    /**
     * Set CabinValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinValue
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setCabinValue($cabinValue = null)
    {
        // validation for constraint: string
        if (!is_null($cabinValue) && !is_string($cabinValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinValue, true), gettype($cabinValue)), __LINE__);
        }
        if (is_null($cabinValue) || (is_array($cabinValue) && empty($cabinValue))) {
            unset($this->CabinValue);
        } else {
            $this->CabinValue = $cabinValue;
        }
        return $this;
    }
    /**
     * Get DestinationAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportCode()
    {
        return isset($this->DestinationAirportCode) ? $this->DestinationAirportCode : null;
    }
    /**
     * Set DestinationAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportCode
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setDestinationAirportCode($destinationAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportCode) && !is_string($destinationAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportCode, true), gettype($destinationAirportCode)), __LINE__);
        }
        if (is_null($destinationAirportCode) || (is_array($destinationAirportCode) && empty($destinationAirportCode))) {
            unset($this->DestinationAirportCode);
        } else {
            $this->DestinationAirportCode = $destinationAirportCode;
        }
        return $this;
    }
    /**
     * Get FlightDate value
     * @return string|null
     */
    public function getFlightDate()
    {
        return $this->FlightDate;
    }
    /**
     * Set FlightDate value
     * @param string $flightDate
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setFlightDate($flightDate = null)
    {
        // validation for constraint: string
        if (!is_null($flightDate) && !is_string($flightDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightDate, true), gettype($flightDate)), __LINE__);
        }
        $this->FlightDate = $flightDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get LidType value
     * @return string|null
     */
    public function getLidType()
    {
        return $this->LidType;
    }
    /**
     * Set LidType value
     * @uses \EnumType\Enumerations_TypeofLid::valueIsValid()
     * @uses \EnumType\Enumerations_TypeofLid::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lidType
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setLidType($lidType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_TypeofLid::valueIsValid($lidType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_TypeofLid', is_array($lidType) ? implode(', ', $lidType) : var_export($lidType, true), implode(', ', \EnumType\Enumerations_TypeofLid::getValidValues())), __LINE__);
        }
        $this->LidType = $lidType;
        return $this;
    }
    /**
     * Get LidValue value
     * @return int|null
     */
    public function getLidValue()
    {
        return $this->LidValue;
    }
    /**
     * Set LidValue value
     * @param int $lidValue
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setLidValue($lidValue = null)
    {
        // validation for constraint: int
        if (!is_null($lidValue) && !(is_int($lidValue) || ctype_digit($lidValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lidValue, true), gettype($lidValue)), __LINE__);
        }
        $this->LidValue = $lidValue;
        return $this;
    }
    /**
     * Get OriginAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportCode()
    {
        return isset($this->OriginAirportCode) ? $this->OriginAirportCode : null;
    }
    /**
     * Set OriginAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportCode
     * @return \StructType\UpdateInventoryAirCraftLid
     */
    public function setOriginAirportCode($originAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportCode) && !is_string($originAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportCode, true), gettype($originAirportCode)), __LINE__);
        }
        if (is_null($originAirportCode) || (is_array($originAirportCode) && empty($originAirportCode))) {
            unset($this->OriginAirportCode);
        } else {
            $this->OriginAirportCode = $originAirportCode;
        }
        return $this;
    }
}
