<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatCharge StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatCharge
 * @subpackage Structs
 */
class SeatCharge extends AbstractStructBase
{
    /**
     * The RowNumber
     * @var int
     */
    public $RowNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The ServiceCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ServiceCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for SeatCharge
     * @uses SeatCharge::setRowNumber()
     * @uses SeatCharge::setSeat()
     * @uses SeatCharge::setServiceCode()
     * @uses SeatCharge::setAmount()
     * @uses SeatCharge::setCurrency()
     * @param int $rowNumber
     * @param string $seat
     * @param string $serviceCode
     * @param float $amount
     * @param string $currency
     */
    public function __construct($rowNumber = null, $seat = null, $serviceCode = null, $amount = null, $currency = null)
    {
        $this
            ->setRowNumber($rowNumber)
            ->setSeat($seat)
            ->setServiceCode($serviceCode)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatCharge
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\SeatCharge
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \StructType\SeatCharge
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SeatCharge
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\SeatCharge
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
}
