<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatCabinDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatCabinDisplay
 * @subpackage Structs
 */
class SeatCabinDisplay extends AbstractStructBase
{
    /**
     * The CabinClassId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CabinClassId;
    /**
     * The CabinDisplayOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CabinDisplayOrder;
    /**
     * The Capacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Capacity;
    /**
     * The SeatCabinId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatCabinId;
    /**
     * The SeatConfigId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatConfigId;
    /**
     * Constructor method for SeatCabinDisplay
     * @uses SeatCabinDisplay::setCabinClassId()
     * @uses SeatCabinDisplay::setCabinDisplayOrder()
     * @uses SeatCabinDisplay::setCapacity()
     * @uses SeatCabinDisplay::setSeatCabinId()
     * @uses SeatCabinDisplay::setSeatConfigId()
     * @param int $cabinClassId
     * @param int $cabinDisplayOrder
     * @param int $capacity
     * @param int $seatCabinId
     * @param int $seatConfigId
     */
    public function __construct($cabinClassId = null, $cabinDisplayOrder = null, $capacity = null, $seatCabinId = null, $seatConfigId = null)
    {
        $this
            ->setCabinClassId($cabinClassId)
            ->setCabinDisplayOrder($cabinDisplayOrder)
            ->setCapacity($capacity)
            ->setSeatCabinId($seatCabinId)
            ->setSeatConfigId($seatConfigId);
    }
    /**
     * Get CabinClassId value
     * @return int|null
     */
    public function getCabinClassId()
    {
        return $this->CabinClassId;
    }
    /**
     * Set CabinClassId value
     * @param int $cabinClassId
     * @return \StructType\SeatCabinDisplay
     */
    public function setCabinClassId($cabinClassId = null)
    {
        // validation for constraint: int
        if (!is_null($cabinClassId) && !(is_int($cabinClassId) || ctype_digit($cabinClassId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinClassId, true), gettype($cabinClassId)), __LINE__);
        }
        $this->CabinClassId = $cabinClassId;
        return $this;
    }
    /**
     * Get CabinDisplayOrder value
     * @return int|null
     */
    public function getCabinDisplayOrder()
    {
        return $this->CabinDisplayOrder;
    }
    /**
     * Set CabinDisplayOrder value
     * @param int $cabinDisplayOrder
     * @return \StructType\SeatCabinDisplay
     */
    public function setCabinDisplayOrder($cabinDisplayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($cabinDisplayOrder) && !(is_int($cabinDisplayOrder) || ctype_digit($cabinDisplayOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinDisplayOrder, true), gettype($cabinDisplayOrder)), __LINE__);
        }
        $this->CabinDisplayOrder = $cabinDisplayOrder;
        return $this;
    }
    /**
     * Get Capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\SeatCabinDisplay
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get SeatCabinId value
     * @return int|null
     */
    public function getSeatCabinId()
    {
        return $this->SeatCabinId;
    }
    /**
     * Set SeatCabinId value
     * @param int $seatCabinId
     * @return \StructType\SeatCabinDisplay
     */
    public function setSeatCabinId($seatCabinId = null)
    {
        // validation for constraint: int
        if (!is_null($seatCabinId) && !(is_int($seatCabinId) || ctype_digit($seatCabinId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCabinId, true), gettype($seatCabinId)), __LINE__);
        }
        $this->SeatCabinId = $seatCabinId;
        return $this;
    }
    /**
     * Get SeatConfigId value
     * @return int|null
     */
    public function getSeatConfigId()
    {
        return $this->SeatConfigId;
    }
    /**
     * Set SeatConfigId value
     * @param int $seatConfigId
     * @return \StructType\SeatCabinDisplay
     */
    public function setSeatConfigId($seatConfigId = null)
    {
        // validation for constraint: int
        if (!is_null($seatConfigId) && !(is_int($seatConfigId) || ctype_digit($seatConfigId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatConfigId, true), gettype($seatConfigId)), __LINE__);
        }
        $this->SeatConfigId = $seatConfigId;
        return $this;
    }
}
