<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAssignment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatAssignment
 * @subpackage Structs
 */
class SeatAssignment extends AbstractStructBase
{
    /**
     * The RowNumber
     * @var int
     */
    public $RowNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The PassengerTypeCode
     * @var int
     */
    public $PassengerTypeCode;
    /**
     * Constructor method for SeatAssignment
     * @uses SeatAssignment::setRowNumber()
     * @uses SeatAssignment::setSeat()
     * @uses SeatAssignment::setPassengerTypeCode()
     * @param int $rowNumber
     * @param string $seat
     * @param int $passengerTypeCode
     */
    public function __construct($rowNumber = null, $seat = null, $passengerTypeCode = null)
    {
        $this
            ->setRowNumber($rowNumber)
            ->setSeat($seat)
            ->setPassengerTypeCode($passengerTypeCode);
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatAssignment
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\SeatAssignment
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return int|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param int $passengerTypeCode
     * @return \StructType\SeatAssignment
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($passengerTypeCode) && !(is_int($passengerTypeCode) || ctype_digit($passengerTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
}
