<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalFlight StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalFlight
 * @subpackage Structs
 */
class PhysicalFlight extends AbstractStructBase
{
    /**
     * The PhysicalFlightID
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The OriginName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OriginName;
    /**
     * The DestinationName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DestinationName;
    /**
     * The TailNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TailNum;
    /**
     * The FlightNum
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNum;
    /**
     * The IsCircularFlight
     * @var bool
     */
    public $IsCircularFlight;
    /**
     * The LegOrder
     * @var int
     */
    public $LegOrder;
    /**
     * The DisplayLegOnSeatmap
     * @var bool
     */
    public $DisplayLegOnSeatmap;
    /**
     * The SeatCodes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatCode
     */
    public $SeatCodes;
    /**
     * The Cabins
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCabin
     */
    public $Cabins;
    /**
     * Constructor method for PhysicalFlight
     * @uses PhysicalFlight::setPhysicalFlightID()
     * @uses PhysicalFlight::setDepartureDate()
     * @uses PhysicalFlight::setOrigin()
     * @uses PhysicalFlight::setDestination()
     * @uses PhysicalFlight::setOriginName()
     * @uses PhysicalFlight::setDestinationName()
     * @uses PhysicalFlight::setTailNum()
     * @uses PhysicalFlight::setFlightNum()
     * @uses PhysicalFlight::setIsCircularFlight()
     * @uses PhysicalFlight::setLegOrder()
     * @uses PhysicalFlight::setDisplayLegOnSeatmap()
     * @uses PhysicalFlight::setSeatCodes()
     * @uses PhysicalFlight::setCabins()
     * @param int $physicalFlightID
     * @param string $departureDate
     * @param string $origin
     * @param string $destination
     * @param string $originName
     * @param string $destinationName
     * @param string $tailNum
     * @param string $flightNum
     * @param bool $isCircularFlight
     * @param int $legOrder
     * @param bool $displayLegOnSeatmap
     * @param \ArrayType\ArrayOfSeatCode $seatCodes
     * @param \ArrayType\ArrayOfCabin $cabins
     */
    public function __construct($physicalFlightID = null, $departureDate = null, $origin = null, $destination = null, $originName = null, $destinationName = null, $tailNum = null, $flightNum = null, $isCircularFlight = null, $legOrder = null, $displayLegOnSeatmap = null, \ArrayType\ArrayOfSeatCode $seatCodes = null, \ArrayType\ArrayOfCabin $cabins = null)
    {
        $this
            ->setPhysicalFlightID($physicalFlightID)
            ->setDepartureDate($departureDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setOriginName($originName)
            ->setDestinationName($destinationName)
            ->setTailNum($tailNum)
            ->setFlightNum($flightNum)
            ->setIsCircularFlight($isCircularFlight)
            ->setLegOrder($legOrder)
            ->setDisplayLegOnSeatmap($displayLegOnSeatmap)
            ->setSeatCodes($seatCodes)
            ->setCabins($cabins);
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\PhysicalFlight
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\PhysicalFlight
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\PhysicalFlight
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\PhysicalFlight
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get OriginName value
     * @return string|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param string $originName
     * @return \StructType\PhysicalFlight
     */
    public function setOriginName($originName = null)
    {
        // validation for constraint: string
        if (!is_null($originName) && !is_string($originName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originName, true), gettype($originName)), __LINE__);
        }
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return string|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param string $destinationName
     * @return \StructType\PhysicalFlight
     */
    public function setDestinationName($destinationName = null)
    {
        // validation for constraint: string
        if (!is_null($destinationName) && !is_string($destinationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationName, true), gettype($destinationName)), __LINE__);
        }
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get TailNum value
     * @return string|null
     */
    public function getTailNum()
    {
        return $this->TailNum;
    }
    /**
     * Set TailNum value
     * @param string $tailNum
     * @return \StructType\PhysicalFlight
     */
    public function setTailNum($tailNum = null)
    {
        // validation for constraint: string
        if (!is_null($tailNum) && !is_string($tailNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tailNum, true), gettype($tailNum)), __LINE__);
        }
        $this->TailNum = $tailNum;
        return $this;
    }
    /**
     * Get FlightNum value
     * @return string|null
     */
    public function getFlightNum()
    {
        return $this->FlightNum;
    }
    /**
     * Set FlightNum value
     * @param string $flightNum
     * @return \StructType\PhysicalFlight
     */
    public function setFlightNum($flightNum = null)
    {
        // validation for constraint: string
        if (!is_null($flightNum) && !is_string($flightNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNum, true), gettype($flightNum)), __LINE__);
        }
        $this->FlightNum = $flightNum;
        return $this;
    }
    /**
     * Get IsCircularFlight value
     * @return bool|null
     */
    public function getIsCircularFlight()
    {
        return $this->IsCircularFlight;
    }
    /**
     * Set IsCircularFlight value
     * @param bool $isCircularFlight
     * @return \StructType\PhysicalFlight
     */
    public function setIsCircularFlight($isCircularFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCircularFlight) && !is_bool($isCircularFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCircularFlight, true), gettype($isCircularFlight)), __LINE__);
        }
        $this->IsCircularFlight = $isCircularFlight;
        return $this;
    }
    /**
     * Get LegOrder value
     * @return int|null
     */
    public function getLegOrder()
    {
        return $this->LegOrder;
    }
    /**
     * Set LegOrder value
     * @param int $legOrder
     * @return \StructType\PhysicalFlight
     */
    public function setLegOrder($legOrder = null)
    {
        // validation for constraint: int
        if (!is_null($legOrder) && !(is_int($legOrder) || ctype_digit($legOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legOrder, true), gettype($legOrder)), __LINE__);
        }
        $this->LegOrder = $legOrder;
        return $this;
    }
    /**
     * Get DisplayLegOnSeatmap value
     * @return bool|null
     */
    public function getDisplayLegOnSeatmap()
    {
        return $this->DisplayLegOnSeatmap;
    }
    /**
     * Set DisplayLegOnSeatmap value
     * @param bool $displayLegOnSeatmap
     * @return \StructType\PhysicalFlight
     */
    public function setDisplayLegOnSeatmap($displayLegOnSeatmap = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayLegOnSeatmap) && !is_bool($displayLegOnSeatmap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayLegOnSeatmap, true), gettype($displayLegOnSeatmap)), __LINE__);
        }
        $this->DisplayLegOnSeatmap = $displayLegOnSeatmap;
        return $this;
    }
    /**
     * Get SeatCodes value
     * @return \ArrayType\ArrayOfSeatCode|null
     */
    public function getSeatCodes()
    {
        return $this->SeatCodes;
    }
    /**
     * Set SeatCodes value
     * @param \ArrayType\ArrayOfSeatCode $seatCodes
     * @return \StructType\PhysicalFlight
     */
    public function setSeatCodes(\ArrayType\ArrayOfSeatCode $seatCodes = null)
    {
        $this->SeatCodes = $seatCodes;
        return $this;
    }
    /**
     * Get Cabins value
     * @return \ArrayType\ArrayOfCabin|null
     */
    public function getCabins()
    {
        return $this->Cabins;
    }
    /**
     * Set Cabins value
     * @param \ArrayType\ArrayOfCabin $cabins
     * @return \StructType\PhysicalFlight
     */
    public function setCabins(\ArrayType\ArrayOfCabin $cabins = null)
    {
        $this->Cabins = $cabins;
        return $this;
    }
}
