<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogicalFlightInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LogicalFlightInfo
 * @subpackage Structs
 */
class LogicalFlightInfo extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The LogicalFlightID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The LogicalFlightStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightStatus;
    /**
     * The OperatingFlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The PhysicalFlights
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfPhysicalFlightInfo
     */
    public $PhysicalFlights;
    /**
     * Constructor method for LogicalFlightInfo
     * @uses LogicalFlightInfo::setArrivalDate()
     * @uses LogicalFlightInfo::setDepartureDate()
     * @uses LogicalFlightInfo::setDestination()
     * @uses LogicalFlightInfo::setLogicalFlightID()
     * @uses LogicalFlightInfo::setLogicalFlightStatus()
     * @uses LogicalFlightInfo::setOperatingFlightNumber()
     * @uses LogicalFlightInfo::setOrigin()
     * @uses LogicalFlightInfo::setPhysicalFlights()
     * @param string $arrivalDate
     * @param string $departureDate
     * @param string $destination
     * @param int $logicalFlightID
     * @param string $logicalFlightStatus
     * @param string $operatingFlightNumber
     * @param string $origin
     * @param \ArrayType\ArrayOfPhysicalFlightInfo $physicalFlights
     */
    public function __construct($arrivalDate = null, $departureDate = null, $destination = null, $logicalFlightID = null, $logicalFlightStatus = null, $operatingFlightNumber = null, $origin = null, \ArrayType\ArrayOfPhysicalFlightInfo $physicalFlights = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate)
            ->setDestination($destination)
            ->setLogicalFlightID($logicalFlightID)
            ->setLogicalFlightStatus($logicalFlightStatus)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setOrigin($origin)
            ->setPhysicalFlights($physicalFlights);
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\LogicalFlightInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\LogicalFlightInfo
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\LogicalFlightInfo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\LogicalFlightInfo
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get LogicalFlightStatus value
     * @return string|null
     */
    public function getLogicalFlightStatus()
    {
        return $this->LogicalFlightStatus;
    }
    /**
     * Set LogicalFlightStatus value
     * @param string $logicalFlightStatus
     * @return \StructType\LogicalFlightInfo
     */
    public function setLogicalFlightStatus($logicalFlightStatus = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightStatus) && !is_string($logicalFlightStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightStatus, true), gettype($logicalFlightStatus)), __LINE__);
        }
        $this->LogicalFlightStatus = $logicalFlightStatus;
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return $this->OperatingFlightNumber;
    }
    /**
     * Set OperatingFlightNumber value
     * @param string $operatingFlightNumber
     * @return \StructType\LogicalFlightInfo
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingFlightNumber, true), gettype($operatingFlightNumber)), __LINE__);
        }
        $this->OperatingFlightNumber = $operatingFlightNumber;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\LogicalFlightInfo
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get PhysicalFlights value
     * @return \ArrayType\ArrayOfPhysicalFlightInfo|null
     */
    public function getPhysicalFlights()
    {
        return $this->PhysicalFlights;
    }
    /**
     * Set PhysicalFlights value
     * @param \ArrayType\ArrayOfPhysicalFlightInfo $physicalFlights
     * @return \StructType\LogicalFlightInfo
     */
    public function setPhysicalFlights(\ArrayType\ArrayOfPhysicalFlightInfo $physicalFlights = null)
    {
        $this->PhysicalFlights = $physicalFlights;
        return $this;
    }
}
